/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.config;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.config.ResequencerConfig;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration,eip")
@XmlRootElement(name="streamConfig")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StreamResequencerConfig
extends ResequencerConfig {
    @XmlTransient
    private ExpressionResultComparator comparatorBean;
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.lang.Integer")
    private String capacity;
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.time.Duration")
    private String timeout;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="1000", javaType="java.time.Duration")
    private String deliveryAttemptInterval;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String ignoreInvalidExchanges;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String rejectOld;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.processor.resequencer.ExpressionResultComparator")
    private String comparator;

    public StreamResequencerConfig() {
        this(1000, 1000L);
    }

    public StreamResequencerConfig(int capacity, long timeout) {
        this(capacity, timeout, null, null);
    }

    public StreamResequencerConfig(int capacity, long timeout, ExpressionResultComparator comparator) {
        this(capacity, timeout, null, comparator);
    }

    public StreamResequencerConfig(int capacity, long timeout, Boolean rejectOld) {
        this(capacity, timeout, rejectOld, null);
    }

    public StreamResequencerConfig(int capacity, long timeout, Boolean rejectOld, ExpressionResultComparator comparator) {
        this.capacity = Integer.toString(capacity);
        this.timeout = Long.toString(timeout);
        this.rejectOld = rejectOld != null ? Boolean.toString(rejectOld) : null;
        this.comparatorBean = comparator;
    }

    protected StreamResequencerConfig(StreamResequencerConfig source) {
        this.comparatorBean = source.comparatorBean;
        this.capacity = source.capacity;
        this.timeout = source.timeout;
        this.deliveryAttemptInterval = source.deliveryAttemptInterval;
        this.ignoreInvalidExchanges = source.ignoreInvalidExchanges;
        this.rejectOld = source.rejectOld;
        this.comparator = source.comparator;
    }

    @Override
    public StreamResequencerConfig copyDefinition() {
        return new StreamResequencerConfig(this);
    }

    public static StreamResequencerConfig getDefault() {
        return new StreamResequencerConfig();
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getDeliveryAttemptInterval() {
        return this.deliveryAttemptInterval;
    }

    public void setDeliveryAttemptInterval(String deliveryAttemptInterval) {
        this.deliveryAttemptInterval = deliveryAttemptInterval;
    }

    public String getIgnoreInvalidExchanges() {
        return this.ignoreInvalidExchanges;
    }

    public void setIgnoreInvalidExchanges(String ignoreInvalidExchanges) {
        this.ignoreInvalidExchanges = ignoreInvalidExchanges;
    }

    public ExpressionResultComparator getComparatorBean() {
        return this.comparatorBean;
    }

    public void setComparatorBean(ExpressionResultComparator comparatorBean) {
        this.comparatorBean = comparatorBean;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public void setRejectOld(String value) {
        this.rejectOld = value;
    }

    public String getRejectOld() {
        return this.rejectOld;
    }
}

