/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.util.StringHelper;

public final class AnnotationHelper {
    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return AnnotationHelper.findMethodsWithAnnotation(type, annotationType, false);
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (!AnnotationHelper.hasAnnotation(method, annotationType, checkMetaAnnotations)) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    public static boolean hasAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        if (elem.isAnnotationPresent(annotationType)) {
            return true;
        }
        if (checkMetaAnnotations) {
            for (Annotation a : elem.getAnnotations()) {
                for (Annotation meta : a.annotationType().getAnnotations()) {
                    if (!meta.annotationType().getName().equals(annotationType.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getAnnotationValue(Class<?> clazz, String fqnAnnotationName) {
        for (Annotation ann : clazz.getAnnotations()) {
            if (!ann.annotationType().getName().equals(fqnAnnotationName)) continue;
            String s = ann.toString();
            return StringHelper.between(s, "\"", "\"");
        }
        return null;
    }

    public static boolean hasAnnotation(Class<?> clazz, String fqnAnnotationName) {
        for (Annotation ann : clazz.getAnnotations()) {
            if (!ann.annotationType().getName().equals(fqnAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(Method method, String fqnAnnotationName) {
        for (Annotation ann : method.getAnnotations()) {
            if (!ann.annotationType().getName().equals(fqnAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public static String getAnnotationValue(Method method, String fqnAnnotationName) {
        return (String)AnnotationHelper.getAnnotationValue(method, fqnAnnotationName, "value");
    }

    public static Object getAnnotationValue(Method method, String fqnAnnotationName, String key) {
        for (Annotation ann : method.getAnnotations()) {
            if (!ann.annotationType().getName().equals(fqnAnnotationName)) continue;
            try {
                Method m = ann.getClass().getDeclaredMethod(key, new Class[0]);
                return m.invoke((Object)ann, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static boolean hasAnnotation(Field field, String fqnAnnotationName) {
        for (Annotation ann : field.getAnnotations()) {
            if (!ann.annotationType().getName().equals(fqnAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public static String getAnnotationValue(Field field, String fqnAnnotationName) {
        return (String)AnnotationHelper.getAnnotationValue(field, fqnAnnotationName, "value");
    }

    public static Object getAnnotationValue(Field field, String fqnAnnotationName, String key) {
        for (Annotation ann : field.getAnnotations()) {
            if (!ann.annotationType().getName().equals(fqnAnnotationName)) continue;
            try {
                Method m = ann.getClass().getDeclaredMethod(key, new Class[0]);
                return m.invoke((Object)ann, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

