/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.xbean.spring.context.impl.NamespaceHelper;
import org.apache.xbean.spring.generator.AttributeMapping;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.MapMapping;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.ParameterMapping;

public class XmlMetadataGenerator
implements GeneratorPlugin {
    private final String metaInfDir;
    private LogFacade log;
    private final File schema;
    public static final String NAMESPACE_HANDLER = "org.apache.xbean.spring.context.v2.XBeanNamespaceHandler";
    private final boolean generateSpringSchemasFile;
    private final boolean generateSpringHandlersFile;

    public XmlMetadataGenerator(String metaInfDir, File schema) {
        this(metaInfDir, schema, true, true);
    }

    public XmlMetadataGenerator(String metaInfDir, File schema, boolean generateSpringSchemasFile, boolean generateSpringHandlersFile) {
        this.metaInfDir = metaInfDir;
        this.schema = schema;
        this.generateSpringSchemasFile = generateSpringSchemasFile;
        this.generateSpringHandlersFile = generateSpringHandlersFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(NamespaceMapping namespaceMapping) throws IOException {
        String namespace = namespaceMapping.getNamespace();
        if (namespace == null) {
            return;
        }
        File file = new File(this.metaInfDir, NamespaceHelper.createDiscoveryPathName(namespace));
        file.getParentFile().mkdirs();
        this.log.log("Generating META-INF properties file: " + file + " for namespace: " + namespace);
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            this.generatePropertiesFile(out, namespaceMapping.getElements());
        }
        if (this.generateSpringHandlersFile) {
            file = new File(this.metaInfDir, "META-INF/spring.handlers");
            Properties properties = new Properties();
            if (!file.exists()) {
                this.log.log("Generating Spring 2.0 handler mapping: " + file + " for namespace: " + namespace);
            } else {
                this.log.log("Updating Spring 2.0 handler mapping: " + file + " for namespace: " + namespace);
                FileInputStream in = new FileInputStream(file);
                try {
                    properties.load(in);
                }
                catch (IOException e) {
                    ((InputStream)in).close();
                }
            }
            properties.put(namespace, NAMESPACE_HANDLER);
            try (FileOutputStream fout = new FileOutputStream(file);){
                properties.store(fout, "Generated by xbean-spring");
            }
        }
        if (this.schema != null && this.generateSpringSchemasFile) {
            String cp = new File(this.metaInfDir).toURI().relativize(this.schema.toURI()).toString();
            file = new File(this.metaInfDir, "META-INF/spring.schemas");
            Properties properties = new Properties();
            if (!file.exists()) {
                this.log.log("Generating Spring 2.0 schema mapping: " + file + " for namespace: " + namespace);
            } else {
                this.log.log("Updating Spring 2.0 schema mapping: " + file + " for namespace: " + namespace);
                FileInputStream in = new FileInputStream(file);
                try {
                    properties.load(in);
                }
                catch (IOException e) {
                    ((InputStream)in).close();
                }
            }
            String uri = namespace;
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            properties.put(uri + cp, cp);
            try (FileOutputStream fout = new FileOutputStream(file);){
                properties.store(fout, "Generated by xbean-spring");
            }
        }
    }

    private void generatePropertiesFile(PrintWriter out, Set elements) {
        out.println("# NOTE: this file is autogenerated by Apache XBean");
        out.println();
        out.println("# beans");
        for (ElementMapping element : elements) {
            out.println(element.getElementName() + " = " + element.getClassName());
            this.generatePropertiesFileContent(out, element);
            this.generatePropertiesFilePropertyAliases(out, element);
            this.generatePropertiesFileConstructors(out, element);
            out.println();
        }
    }

    private void generatePropertiesFileContent(PrintWriter out, ElementMapping element) {
        String factoryMethod;
        String destroyMethod;
        String initMethod;
        String contentProperty = element.getContentProperty();
        if (contentProperty != null) {
            out.println(element.getElementName() + ".contentProperty = " + contentProperty);
        }
        if ((initMethod = element.getInitMethod()) != null) {
            out.println(element.getElementName() + ".initMethod = " + initMethod);
        }
        if ((destroyMethod = element.getDestroyMethod()) != null) {
            out.println(element.getElementName() + ".destroyMethod = " + destroyMethod);
        }
        if ((factoryMethod = element.getFactoryMethod()) != null) {
            out.println(element.getElementName() + ".factoryMethod = " + factoryMethod);
        }
        for (AttributeMapping attribute : element.getAttributes()) {
            if (attribute.getPropertyEditor() == null) continue;
            out.println(element.getElementName() + "." + attribute.getPropertyName() + ".propertyEditor = " + attribute.getPropertyEditor());
        }
        List flatProperties = element.getFlatProperties();
        Iterator itr = flatProperties.iterator();
        while (itr.hasNext()) {
            out.println(element.getElementName() + "." + itr.next() + ".flat");
        }
        Map maps = element.getMapMappings();
        for (Map.Entry entry : maps.entrySet()) {
            MapMapping mm = (MapMapping)entry.getValue();
            if (mm.getEntryName() != null) {
                out.println(element.getElementName() + "." + entry.getKey() + ".map.entryName = " + mm.getEntryName());
            }
            if (mm.getKeyName() != null) {
                out.println(element.getElementName() + "." + entry.getKey() + ".map.keyName = " + mm.getKeyName());
            }
            if (mm.isFlat()) {
                out.println(element.getElementName() + "." + entry.getKey() + ".map.flat = " + Boolean.toString(mm.isFlat()));
            }
            if (mm.getDupsMode() != null) {
                out.println(element.getElementName() + "." + entry.getKey() + ".map.dups = " + mm.getDupsMode());
            }
            if (mm.getDefaultKey() == null) continue;
            out.println(element.getElementName() + "." + entry.getKey() + ".map.defaultKey = " + mm.getDefaultKey());
        }
        Map flatCollections = element.getFlatCollections();
        for (Map.Entry entry : flatCollections.entrySet()) {
            String child = (String)entry.getValue();
            out.println(element.getElementName() + "." + child + ".flatCollection = " + entry.getKey());
        }
    }

    private void generatePropertiesFileConstructors(PrintWriter out, ElementMapping element) {
        List constructors = element.getConstructors();
        for (List args : constructors) {
            this.generatePropertiesFileConstructor(out, element, args);
        }
    }

    private void generatePropertiesFileConstructor(PrintWriter out, ElementMapping element, List args) {
        out.print(element.getClassName());
        if (element.getFactoryMethod() != null) {
            out.print("." + element.getFactoryMethod());
        }
        out.print("(");
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            ParameterMapping parameterMapping = (ParameterMapping)iterator.next();
            out.print(parameterMapping.getType().getName());
            if (!iterator.hasNext()) continue;
            out.print(",");
        }
        out.print(").parameterNames =");
        for (ParameterMapping parameterMapping : args) {
            out.print(" ");
            out.print(parameterMapping.getName());
        }
        out.println();
    }

    private void generatePropertiesFilePropertyAliases(PrintWriter out, ElementMapping element) {
        for (AttributeMapping attributeMapping : element.getAttributes()) {
            String attributeName;
            String propertyName = attributeMapping.getPropertyName();
            if (propertyName.equals(attributeName = attributeMapping.getAttributeName())) continue;
            if (List.class.getName().equals(attributeMapping.getType().getName())) {
                out.println(element.getElementName() + ".list." + attributeName + " = " + propertyName);
                continue;
            }
            out.println(element.getElementName() + ".alias." + attributeName + " = " + propertyName);
        }
    }

    @Override
    public LogFacade getLog() {
        return this.log;
    }

    @Override
    public void setLog(LogFacade log) {
        this.log = log;
    }
}

