/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.activation;

import jakarta.activation.DataHandler;
import java.text.ParseException;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.om.format.xop.ContentTypeProvider;
import org.apache.axiom.util.activation.DataHandlerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataHandlerContentTypeProvider
implements ContentTypeProvider {
    private static final Log log = LogFactory.getLog(DataHandlerContentTypeProvider.class);
    public static final DataHandlerContentTypeProvider INSTANCE = new DataHandlerContentTypeProvider();

    private DataHandlerContentTypeProvider() {
    }

    public ContentType getContentType(Blob blob) {
        DataHandler dh = DataHandlerUtils.getDataHandler(blob);
        if (dh == null) {
            return null;
        }
        String contentType = dh.getContentType();
        if (contentType == null) {
            return null;
        }
        try {
            return new ContentType(contentType);
        }
        catch (ParseException ex) {
            log.warn((Object)"Couldn't parse content type returned by DataHandler", (Throwable)ex);
            return null;
        }
    }
}

