/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.woden.WSDLException;
import org.apache.woden.resolver.URIResolver;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.xml.sax.InputSource;

public class WarBasedWSDLLocator
extends DefaultURIResolver
implements WSDLLocator,
URIResolver {
    protected static final Log log = LogFactory.getLog(WarBasedWSDLLocator.class);
    private InputStream baseInputStream;
    private URI lastImportLocation;
    private String baseURI;
    private ClassLoader classLoader;

    public WarBasedWSDLLocator(String baseURI, ClassLoader classLoader, InputStream baseInputStream) {
        this.baseURI = baseURI;
        this.baseInputStream = baseInputStream;
        this.classLoader = classLoader;
    }

    public InputSource getBaseInputSource() {
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        this.lastImportLocation = URI.create(parentLocation).resolve(importLocation);
        if (this.isAbsolute(importLocation)) {
            return super.resolveEntity(null, importLocation, parentLocation);
        }
        String searchingStr = this.lastImportLocation.toString();
        return new InputSource(this.classLoader.getResourceAsStream(searchingStr));
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getLatestImportURI() {
        return this.lastImportLocation.toString();
    }

    public void close() {
    }

    public URI resolveURI(URI uri) throws WSDLException, IOException {
        if (this.isAbsolute(uri.toString())) {
            return uri;
        }
        this.lastImportLocation = URI.create(this.baseURI).resolve(uri.toString());
        String searchingStr = this.lastImportLocation.toString();
        URL resource = this.classLoader.getResource(searchingStr);
        if (resource != null) {
            try {
                return new URI(resource.toString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        log.info((Object)("AARBasedWSDLLocator: Unable to resolve " + String.valueOf(this.lastImportLocation)));
        return null;
    }
}

