/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.calendar.internal;

import java.lang.reflect.Method;
import java.util.List;

import com.google.api.services.calendar.Calendar.Events;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for com.google.api.services.calendar.Calendar$Events
 */
public enum CalendarEventsApiMethod implements ApiMethod {

    CALENDAR_IMPORT(
        com.google.api.services.calendar.Calendar.Events.CalendarImport.class,
        "calendarImport",
        arg("calendarId", String.class),
        arg("content", com.google.api.services.calendar.model.Event.class)),

    DELETE(
        com.google.api.services.calendar.Calendar.Events.Delete.class,
        "delete",
        arg("calendarId", String.class),
        arg("eventId", String.class)),

    GET(
        com.google.api.services.calendar.Calendar.Events.Get.class,
        "get",
        arg("calendarId", String.class),
        arg("eventId", String.class)),

    INSERT(
        com.google.api.services.calendar.Calendar.Events.Insert.class,
        "insert",
        arg("calendarId", String.class),
        arg("content", com.google.api.services.calendar.model.Event.class)),

    INSTANCES(
        com.google.api.services.calendar.Calendar.Events.Instances.class,
        "instances",
        arg("calendarId", String.class),
        arg("eventId", String.class)),

    LIST(
        com.google.api.services.calendar.Calendar.Events.List.class,
        "list",
        arg("calendarId", String.class)),

    MOVE(
        com.google.api.services.calendar.Calendar.Events.Move.class,
        "move",
        arg("calendarId", String.class),
        arg("eventId", String.class),
        arg("destination", String.class)),

    PATCH(
        com.google.api.services.calendar.Calendar.Events.Patch.class,
        "patch",
        arg("calendarId", String.class),
        arg("eventId", String.class),
        arg("content", com.google.api.services.calendar.model.Event.class)),

    QUICK_ADD(
        com.google.api.services.calendar.Calendar.Events.QuickAdd.class,
        "quickAdd",
        arg("calendarId", String.class),
        arg("text", String.class)),

    UPDATE(
        com.google.api.services.calendar.Calendar.Events.Update.class,
        "update",
        arg("calendarId", String.class),
        arg("eventId", String.class),
        arg("content", com.google.api.services.calendar.model.Event.class)),

    WATCH(
        com.google.api.services.calendar.Calendar.Events.Watch.class,
        "watch",
        arg("calendarId", String.class),
        arg("contentChannel", com.google.api.services.calendar.model.Channel.class));

    private final ApiMethod apiMethod;

    private CalendarEventsApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(Events.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
