/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.spi;

import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;

/**
 * Local {@link CliConnector} that allows Camel CLI to manage local running Camel integrations.
 */
public interface CliConnector extends StaticService, NonManagedService {

    /**
     * Signal to terminate Camel and the JVM.
     *
     * The Camel CLI can trigger this by the command: camel stop PID
     */
    void sigterm();

    /**
     * Allows to adjust the frequency delay which the CliConnect reacts. Uses 1000 millis by default.
     *
     * @param delay delay in millis
     */
    void updateDelay(int delay);

}
