/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExceptionHandlerTest
extends AbstractJXPathTest {
    private JXPathContext context;
    private final Bar bar = new Bar();

    public Bar getBar() {
        return this.bar;
    }

    public Object getFoo() {
        throw new IllegalStateException("foo unavailable");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.context = JXPathContext.newContext((Object)this);
        this.context.setExceptionHandler((t, ptr) -> {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException((Throwable)t);
        });
    }

    @Test
    public void testHandleBarBaz() throws Exception {
        for (Throwable t = Assertions.assertThrows(Throwable.class, () -> this.context.getValue("bar/baz"), (String)"expected Throwable"); t != null; t = t.getCause()) {
            if (!"baz unavailable".equals(t.getMessage())) continue;
            return;
        }
        Assertions.fail((String)"expected \"baz unavailable\" in throwable chain");
    }

    @Test
    public void testHandleFoo() throws Exception {
        for (Throwable t = Assertions.assertThrows(Throwable.class, () -> this.context.getValue("foo"), (String)"expected Throwable"); t != null; t = t.getCause()) {
            if (!"foo unavailable".equals(t.getMessage())) continue;
            return;
        }
        Assertions.fail((String)"expected \"foo unavailable\" in throwable chain");
    }

    public static class Bar {
        public Object getBaz() {
            throw new IllegalStateException("baz unavailable");
        }
    }
}

