/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int LG_RESIZE_FACTOR_BIT = 6;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int LG_NOM_LONGS_BYTE = 3;
    static final int LG_ARR_LONGS_BYTE = 4;
    static final int FLAGS_BYTE = 5;
    static final int SEED_HASH_SHORT = 6;
    static final int RETAINED_ENTRIES_INT = 8;
    static final int P_FLOAT = 12;
    static final int THETA_LONG = 16;
    static final int UNION_THETA_LONG = 24;
    static final int RESERVED_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final int SINGLEITEM_FLAG_MASK = 32;
    static final int SER_VER = 3;
    static final int SER_VER_COMPRESSED = 4;
    static final int ENTRY_BITS_BYTE_V4 = 3;
    static final int NUM_ENTRIES_BYTES_BYTE_V4 = 4;
    static final int THETA_LONG_V4 = 8;

    private PreambleUtil() {
    }

    static int getUpdatableSegBytes(int lgArrLongs, int preambleLongs) {
        return (8 << lgArrLongs) + (preambleLongs << 3);
    }

    static String preambleToString(byte[] byteArr) {
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return PreambleUtil.preambleToString(seg);
    }

    static String preambleToString(MemorySegment seg) {
        long thetaLong;
        int preLongs = PreambleUtil.checkSegPreambleCap(seg);
        int rfId = PreambleUtil.extractLgResizeFactor(seg);
        ResizeFactor rf = ResizeFactor.getRF(rfId);
        int serVer = PreambleUtil.extractSerVer(seg);
        int familyId = PreambleUtil.extractFamilyID(seg);
        Family family = Family.idToFamily(familyId);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(seg);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(seg);
        int flags = PreambleUtil.extractFlags(seg);
        String flagsStr = flags + ", 0x" + Integer.toHexString(flags) + ", " + Util.zeroPad(Integer.toBinaryString(flags), 8);
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        boolean singleItem = (flags & 0x20) > 0;
        int seedHash = PreambleUtil.extractSeedHash(seg);
        int curCount = singleItem ? 1 : 0;
        float p = 1.0f;
        long thetaULong = thetaLong = Long.MAX_VALUE;
        if (preLongs == 2) {
            curCount = PreambleUtil.extractCurCount(seg);
            p = PreambleUtil.extractP(seg);
        } else if (preLongs == 3) {
            curCount = PreambleUtil.extractCurCount(seg);
            p = PreambleUtil.extractP(seg);
            thetaULong = thetaLong = PreambleUtil.extractThetaLong(seg);
        } else if (preLongs == 4) {
            curCount = PreambleUtil.extractCurCount(seg);
            p = PreambleUtil.extractP(seg);
            thetaLong = PreambleUtil.extractThetaLong(seg);
            thetaULong = PreambleUtil.extractUnionThetaLong(seg);
        }
        double thetaDbl = (double)thetaLong / 9.223372036854776E18;
        String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
        double thetaUDbl = (double)thetaULong / 9.223372036854776E18;
        String thetaUHex = Util.zeroPad(Long.toHexString(thetaULong), 16);
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### SKETCH PREAMBLE SUMMARY:").append(Util.LS);
        sb.append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS);
        sb.append("Byte  0: ResizeFactor         : ").append(rfId + ", " + rf.toString()).append(Util.LS);
        sb.append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS);
        sb.append("Byte  2: Family               : ").append(familyId + ", " + family.toString()).append(Util.LS);
        sb.append("Byte  3: LgNomLongs, LgK      : ").append(lgNomLongs).append(Util.LS);
        sb.append("Byte  4: LgArrLongs           : ").append(lgArrLongs).append(Util.LS);
        sb.append("Byte  5: Flags Field          : ").append(flagsStr).append(Util.LS);
        sb.append("  Bit Flag Name               : State:").append(Util.LS);
        sb.append("    0 RESERVED                : ").append(Util.LS);
        sb.append("    1 READ_ONLY               : ").append(readOnly).append(Util.LS);
        sb.append("    2 EMPTY                   : ").append(empty).append(Util.LS);
        sb.append("    3 COMPACT                 : ").append(compact).append(Util.LS);
        sb.append("    4 ORDERED                 : ").append(ordered).append(Util.LS);
        sb.append("    5 SINGLE_ITEM             : ").append(singleItem).append(Util.LS);
        sb.append("Bytes 6-7  : Seed Hash Hex    : ").append(Integer.toHexString(seedHash)).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT FIELDS, ASSUMED:").append(Util.LS);
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS);
            sb.append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS);
            sb.append("             Theta (long)     : ").append(thetaLong).append(Util.LS);
            sb.append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        } else if (preLongs == 2) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS);
            sb.append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS);
            sb.append("             Theta (long)     : ").append(thetaLong).append(Util.LS);
            sb.append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        } else if (preLongs == 3) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS);
            sb.append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS);
            sb.append("             Theta (long)     : ").append(thetaLong).append(Util.LS);
            sb.append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            if (serVer == 4) {
                sb.append("TOTAL Storage Bytes         : ").append(seg.byteSize()).append(Util.LS);
                sb.append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
                return sb.toString();
            }
        } else {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS);
            sb.append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS);
            sb.append("             Theta (long)     : ").append(thetaLong).append(Util.LS);
            sb.append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            sb.append("Bytes 25-31: ThetaU (double)  : ").append(thetaUDbl).append(Util.LS);
            sb.append("             ThetaU (long)    : ").append(thetaULong).append(Util.LS);
            sb.append("             ThetaU (long,hex): ").append(thetaUHex).append(Util.LS);
        }
        sb.append("Preamble Bytes                : ").append(preLongs * 8).append(Util.LS);
        sb.append("Retained Data Bytes           : ").append(curCount * 8).append(Util.LS);
        sb.append("TOTAL Storage Bytes           : ").append(seg.byteSize()).append(Util.LS);
        sb.append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F;
    }

    static int extractLgResizeFactor(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 0L) >>> 6 & 3;
    }

    static int extractSerVer(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 1L) & 0xFF;
    }

    static int extractFamilyID(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 2L) & 0xFF;
    }

    static int extractLgNomLongs(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 3L) & 0xFF;
    }

    static int extractLgArrLongs(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 4L) & 0xFF;
    }

    static int extractFlags(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 5L) & 0xFF;
    }

    static int extractSeedHash(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 6L) & 0xFFFF;
    }

    static int extractCurCount(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, 8L);
    }

    static float extractP(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 12L);
    }

    static long extractThetaLong(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 16L);
    }

    static long extractUnionThetaLong(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 24L);
    }

    static int extractEntryBitsV4(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 3L) & 0xFF;
    }

    static int extractNumEntriesBytesV4(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 4L) & 0xFF;
    }

    static long extractThetaLongV4(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    static void insertPreLongs(MemorySegment seg, int preLongs) {
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)(preLongs & 0x3F));
    }

    static void insertLgResizeFactor(MemorySegment seg, int rf) {
        int curByte = seg.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
        int shift = 6;
        int mask = 3;
        byte newByte = (byte)((rf & 3) << 6 | 0xFFFFFF3F & curByte);
        seg.set(ValueLayout.JAVA_BYTE, 0L, newByte);
    }

    static void insertSerVer(MemorySegment seg, int serVer) {
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)serVer);
    }

    static void insertFamilyID(MemorySegment seg, int famId) {
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)famId);
    }

    static void insertLgNomLongs(MemorySegment seg, int lgNomLongs) {
        seg.set(ValueLayout.JAVA_BYTE, 3L, (byte)lgNomLongs);
    }

    static void insertLgArrLongs(MemorySegment seg, int lgArrLongs) {
        seg.set(ValueLayout.JAVA_BYTE, 4L, (byte)lgArrLongs);
    }

    static void insertFlags(MemorySegment seg, int flags) {
        seg.set(ValueLayout.JAVA_BYTE, 5L, (byte)flags);
    }

    static void insertSeedHash(MemorySegment seg, int seedHash) {
        seg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, (short)seedHash);
    }

    static void insertCurCount(MemorySegment seg, int curCount) {
        seg.set(ValueLayout.JAVA_INT_UNALIGNED, 8L, curCount);
    }

    static void insertP(MemorySegment seg, float p) {
        seg.set(ValueLayout.JAVA_FLOAT_UNALIGNED, 12L, p);
    }

    static void insertThetaLong(MemorySegment seg, long thetaLong) {
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, thetaLong);
    }

    static void insertUnionThetaLong(MemorySegment seg, long unionThetaLong) {
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 24L, unionThetaLong);
    }

    static void setEmpty(MemorySegment seg) {
        int flags = seg.get(ValueLayout.JAVA_BYTE, 5L) & 0xFF;
        seg.set(ValueLayout.JAVA_BYTE, 5L, (byte)(flags |= 4));
    }

    static void clearEmpty(MemorySegment seg) {
        int flags = seg.get(ValueLayout.JAVA_BYTE, 5L) & 0xFF;
        seg.set(ValueLayout.JAVA_BYTE, 5L, (byte)(flags &= 0xFFFFFFFB));
    }

    static boolean isEmptyFlag(MemorySegment seg) {
        return (PreambleUtil.extractFlags(seg) & 4) > 0;
    }

    static int checkSegPreambleCap(MemorySegment seg) {
        try {
            int preLongs = PreambleUtil.extractPreLongs(seg);
            int required = Math.max(preLongs << 3, 8);
            long cap = seg.byteSize();
            if (cap < (long)required) {
                PreambleUtil.throwNotBigEnough(cap, required);
            }
            return preLongs;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SketchesArgumentException("Possible Corruption: Given MemorySegment is empty.");
        }
    }

    static short checkSegmentSeedHash(MemorySegment seg, long seed) {
        short seedHashSeg = (short)PreambleUtil.extractSeedHash(seg);
        Util.checkSeedHashes(seedHashSeg, Util.computeSeedHash(seed));
        return seedHashSeg;
    }

    private static void throwNotBigEnough(long cap, long required) {
        throw new SketchesArgumentException("Possible Corruption: Size of MemorySegment not large enough: Size: " + cap + " < Required: " + required);
    }

    static int wholeBytesToHoldBits(int bits) {
        return (bits >>> 3) + ((bits & 7) > 0 ? 1 : 0);
    }
}

