/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.List;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.AuditMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditMgrImpl.class.getName());

    AuditMgrImpl() {
    }

    FortResponse searchBinds(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAudit inAudit = (UserAudit)request.getEntity();
            AuditMgr auditMgr = AuditMgrFactory.createInstance((String)request.getContextId());
            auditMgr.setAdmin(request.getSession());
            List outAudit = auditMgr.searchBinds(inAudit);
            response.setEntities(outAudit);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse getUserAuthZs(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAudit inAudit = (UserAudit)request.getEntity();
            AuditMgr auditMgr = AuditMgrFactory.createInstance((String)request.getContextId());
            auditMgr.setAdmin(request.getSession());
            List outAudit = auditMgr.getUserAuthZs(inAudit);
            response.setEntities(outAudit);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse searchAuthZs(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAudit inAudit = (UserAudit)request.getEntity();
            AuditMgr auditMgr = AuditMgrFactory.createInstance((String)request.getContextId());
            auditMgr.setAdmin(request.getSession());
            List outAudit = auditMgr.searchAuthZs(inAudit);
            response.setEntities(outAudit);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse searchUserSessions(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAudit inAudit = (UserAudit)request.getEntity();
            AuditMgr auditMgr = AuditMgrFactory.createInstance((String)request.getContextId());
            auditMgr.setAdmin(request.getSession());
            List outAudit = auditMgr.searchUserSessions(inAudit);
            response.setEntities(outAudit);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse searchAdminMods(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAudit inAudit = (UserAudit)request.getEntity();
            AuditMgr auditMgr = AuditMgrFactory.createInstance((String)request.getContextId());
            auditMgr.setAdmin(request.getSession());
            List outAudit = auditMgr.searchAdminMods(inAudit);
            response.setEntities(outAudit);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse searchInvalidUsers(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAudit inAudit = (UserAudit)request.getEntity();
            AuditMgr auditMgr = AuditMgrFactory.createInstance((String)request.getContextId());
            auditMgr.setAdmin(request.getSession());
            List outAudit = auditMgr.searchInvalidUsers(inAudit);
            response.setEntities(outAudit);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

