/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.encryption;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.encryption.ReencryptStateUtils;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.BasicRateLimiter;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.typedef.internal.CU;

public class CacheGroupPageScanner
implements CheckpointListener {
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<Integer, GroupScanTask> grps = new ConcurrentHashMap<Integer, GroupScanTask>();
    private final Collection<GroupScanTask> cpWaitGrps = new ConcurrentLinkedQueue<GroupScanTask>();
    private final int batchSize;
    private final BasicRateLimiter limiter;
    private boolean stopped;

    public CacheGroupPageScanner(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        DataStorageConfiguration dsCfg = ctx.config().getDataStorageConfiguration();
        if (ctx.clientNode() || !CU.isPersistenceEnabled(dsCfg)) {
            this.batchSize = -1;
            this.limiter = null;
            return;
        }
        double rateLimit = dsCfg.getEncryptionConfiguration().getReencryptionRateLimit();
        this.limiter = new BasicRateLimiter(this.calcPermits(rateLimit, dsCfg));
        this.batchSize = dsCfg.getEncryptionConfiguration().getReencryptionBatchSize();
    }

    @Override
    public void onCheckpointBegin(CheckpointListener.Context cpCtx) {
    }

    @Override
    public void beforeCheckpointBegin(CheckpointListener.Context cpCtx) {
        HashSet completeCandidates = new HashSet();
        this.cpWaitGrps.removeIf(completeCandidates::add);
        cpCtx.finishedStateFut().listen(f -> {
            if (f.error() != null || f.isCancelled()) {
                this.cpWaitGrps.addAll(completeCandidates);
                return;
            }
            this.lock.lock();
            try {
                for (GroupScanTask grpScanTask : completeCandidates) {
                    this.grps.remove(grpScanTask.group().groupId());
                    grpScanTask.onDone();
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("Cache group reencryption is finished [grp=" + grpScanTask.group().cacheOrGroupName() + "]");
                }
                if (!this.grps.isEmpty()) {
                    return;
                }
                ((GridCacheDatabaseSharedManager)this.ctx.cache().context().database()).removeCheckpointListener(this);
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    @Override
    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<Void> schedule(int grpId) throws IgniteCheckedException {
        CacheGroupContext grp = this.ctx.cache().cacheGroup(grpId);
        if (grp == null || !grp.affinityNode()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Skip reencryption, cache group doesn't exist on the local node [grp=" + grpId + "]");
            }
            return new GridFinishedFuture<Void>();
        }
        GroupScanTask grpScanTask = new GroupScanTask(grp);
        this.lock.lock();
        try {
            GroupScanTask prevState;
            if (this.stopped) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            if (this.grps.isEmpty()) {
                ((GridCacheDatabaseSharedManager)this.ctx.cache().context().database()).addCheckpointListener(this);
            }
            if ((prevState = this.grps.get(grpId)) != null && !prevState.isDone()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reencryption already scheduled [grpId=" + grpId + "]");
                }
                GroupScanTask groupScanTask = prevState;
                return groupScanTask;
            }
            this.grps.put(grpId, grpScanTask);
        }
        finally {
            this.lock.unlock();
        }
        this.ctx.pools().getReencryptionExecutorService().submit(() -> this.schedule0(grpScanTask));
        return grpScanTask;
    }

    private void schedule0(final GroupScanTask grpScanTask) {
        try {
            this.forEachPageStore(grpScanTask.group(), new IgniteInClosureX<Integer>(){

                @Override
                public void applyx(Integer partId) {
                    long encState = CacheGroupPageScanner.this.ctx.encryption().getEncryptionState(grpScanTask.group().groupId(), partId);
                    if (encState != 0L) {
                        grpScanTask.addPartition(partId, encState);
                    }
                }
            });
            if (this.log.isInfoEnabled()) {
                this.log.info("Scheduled reencryption [grp=" + grpScanTask.group().cacheOrGroupName() + "]");
            }
            grpScanTask.checkComplete();
        }
        catch (IgniteCheckedException e) {
            grpScanTask.onDone(e);
        }
    }

    public IgniteInternalFuture<Void> statusFuture(int grpId) {
        GroupScanTask grpScanTask = this.grps.get(grpId);
        return grpScanTask == null ? new GridFinishedFuture() : grpScanTask;
    }

    public void stop() throws IgniteCheckedException {
        this.lock.lock();
        try {
            this.stopped = true;
            for (GroupScanTask grpScanTask : this.grps.values()) {
                grpScanTask.cancel();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean excludePartition(int grpId, int partId) {
        GroupScanTask grpScanTask = this.grps.get(grpId);
        if (grpScanTask == null) {
            return false;
        }
        return grpScanTask.excludePartition(partId);
    }

    public void includePartition(int grpId, int partId) {
        GroupScanTask grpScanTask = this.grps.get(grpId);
        if (grpScanTask != null) {
            grpScanTask.schedulePending(partId);
        }
    }

    public long[] pagesCount(final CacheGroupContext grp) throws IgniteCheckedException {
        final long[] partStates = new long[grp.affinity().partitions() + 1];
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            this.forEachPageStore(grp, new IgniteInClosureX<Integer>(){

                @Override
                public void applyx(Integer partId) throws IgniteCheckedException {
                    int pagesCnt = CacheGroupPageScanner.this.ctx.cache().context().pageStore().pages(grp.groupId(), partId);
                    partStates[Math.min((int)partId.intValue(), (int)(partStates.length - 1))] = pagesCnt;
                }
            });
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
        return partStates;
    }

    public long remainingPagesCount(int grpId) {
        GroupScanTask grpScanTask = this.grps.get(grpId);
        if (grpScanTask != null) {
            return grpScanTask.remainingPagesCount();
        }
        return 0L;
    }

    public double getRate() {
        DataStorageConfiguration dsCfg = this.ctx.config().getDataStorageConfiguration();
        if (CU.isPersistenceEnabled(dsCfg)) {
            return (double)dsCfg.getPageSize() * this.limiter.getRate() / 1048576.0;
        }
        return 0.0;
    }

    public void setRate(double rate) {
        DataStorageConfiguration dsCfg = this.ctx.config().getDataStorageConfiguration();
        if (CU.isPersistenceEnabled(dsCfg)) {
            this.limiter.setRate(this.calcPermits(rate, dsCfg));
        }
    }

    private double calcPermits(double rate, DataStorageConfiguration dsCfg) {
        return rate * 1048576.0 / (double)(dsCfg.getPageSize() == 0 ? 4096 : dsCfg.getPageSize());
    }

    private void forEachPageStore(CacheGroupContext grp, IgniteInClosureX<Integer> hnd) throws IgniteCheckedException {
        int parts = grp.affinity().partitions();
        IgnitePageStoreManager pageStoreMgr = this.ctx.cache().context().pageStore();
        for (int p = 0; p < parts; ++p) {
            if (!pageStoreMgr.exists(grp.groupId(), p)) continue;
            hnd.applyx(p);
        }
        hnd.applyx(65535);
    }

    private class GroupScanTask
    extends GridFutureAdapter<Void> {
        private final CacheGroupContext grp;
        private final Set<Integer> parts = new GridConcurrentHashSet<Integer>();
        private final PageMemoryEx pageMem;
        private final AtomicLong remainingPagesCntr = new AtomicLong();

        public GroupScanTask(CacheGroupContext grp) {
            this.grp = grp;
            this.pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
        }

        public synchronized void addPartition(int partId, long state) {
            this.remainingPagesCntr.addAndGet(ReencryptStateUtils.pageCount(state) - ReencryptStateUtils.pageIndex(state));
            this.parts.add(partId);
            this.schedulePartitionScan(partId);
        }

        @Override
        public synchronized boolean cancel() throws IgniteCheckedException {
            CacheGroupPageScanner.this.grps.remove(this.grp.groupId());
            return this.onCancelled();
        }

        public synchronized boolean excludePartition(int partId) {
            if (!this.parts.remove(partId)) {
                return false;
            }
            long state = CacheGroupPageScanner.this.ctx.encryption().getEncryptionState(this.grp.groupId(), partId);
            long pagesLeft = this.remainingPagesCntr.addAndGet(ReencryptStateUtils.pageIndex(state) - ReencryptStateUtils.pageCount(state));
            if (pagesLeft == 0L) {
                this.checkComplete();
            }
            return true;
        }

        public synchronized void schedulePending(int partId) {
            if (this.isDone()) {
                return;
            }
            if (this.parts.contains(partId)) {
                this.schedulePartitionScan(partId);
            }
        }

        public CacheGroupContext group() {
            return this.grp;
        }

        public long remainingPagesCount() {
            return this.remainingPagesCntr.get();
        }

        private void schedulePartitionScan(int partId) {
            CacheGroupPageScanner.this.ctx.pools().getReencryptionExecutorService().submit(() -> this.scanPartition(partId));
        }

        private synchronized void checkComplete() {
            if (!this.isDone() && this.parts.isEmpty() && !CacheGroupPageScanner.this.cpWaitGrps.contains(this)) {
                CacheGroupPageScanner.this.cpWaitGrps.add(this);
            }
        }

        private boolean evicted(int partId) {
            if (partId == 65535) {
                return false;
            }
            return !this.parts.contains(partId) || this.grp.topology().localPartition(partId).state() == GridDhtPartitionState.EVICTED;
        }

        /*
         * Exception decompiling
         */
        private void scanPartition(int partId) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int scanPages(int partId, int off, int cnt) throws IgniteCheckedException {
            int grpId = this.grp.groupId();
            byte flag = GroupPartitionId.getFlagByPartId(partId);
            for (int pageIdx = off; pageIdx < off + cnt; ++pageIdx) {
                long pageId = PageIdUtils.pageId(partId, flag, pageIdx);
                long page = this.pageMem.acquirePage(grpId, pageId);
                try {
                    if (this.pageMem.isDirty(grpId, pageId, page)) continue;
                    this.pageMem.writeLock(grpId, pageId, page, true);
                    this.pageMem.writeUnlock(grpId, pageId, page, null, true);
                    continue;
                }
                finally {
                    this.pageMem.releasePage(grpId, pageId, page);
                }
            }
            return cnt;
        }
    }
}

