/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionSnapshotWriter;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.startup.StartupPartitionSnapshotReader;
import org.apache.ignite3.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.option.SnapshotCopierOptions;
import org.apache.ignite3.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite3.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite3.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite3.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite3.raft.jraft.storage.snapshot.SnapshotWriter;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotStorageFactory
implements SnapshotStorageFactory {
    private final PartitionSnapshotStorage snapshotStorage;

    public PartitionSnapshotStorageFactory(PartitionSnapshotStorage snapshotStorage) {
        this.snapshotStorage = snapshotStorage;
    }

    @Override
    public SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        return new PartitionSnapshotStorageAdapter(this.snapshotStorage, uri);
    }

    private static class PartitionSnapshotStorageAdapter
    implements SnapshotStorage {
        private final PartitionSnapshotStorage snapshotStorage;
        private final AtomicBoolean startupSnapshotOpened = new AtomicBoolean();
        private final String snapshotUri;

        PartitionSnapshotStorageAdapter(PartitionSnapshotStorage snapshotStorage, String snapshotUri) {
            this.snapshotStorage = snapshotStorage;
            this.snapshotUri = snapshotUri;
        }

        @Override
        public boolean init(Void opts) {
            return true;
        }

        @Override
        public void shutdown() {
        }

        @Override
        @Nullable
        public SnapshotReader open() {
            if (this.startupSnapshotOpened.compareAndSet(false, true)) {
                RaftOutter.SnapshotMeta startupSnapshotMeta = this.snapshotStorage.readStartupSnapshotMeta();
                if (startupSnapshotMeta == null) {
                    return null;
                }
                return new StartupPartitionSnapshotReader(startupSnapshotMeta, this.snapshotUri);
            }
            return this.snapshotStorage.startOutgoingSnapshot();
        }

        @Override
        public SnapshotCopier startToCopyFrom(String uri, SnapshotCopierOptions opts) {
            return this.snapshotStorage.startIncomingSnapshot(uri);
        }

        @Override
        public SnapshotWriter create() {
            return new PartitionSnapshotWriter(this.snapshotUri);
        }

        @Override
        public void setSnapshotThrottle(SnapshotThrottle snapshotThrottle) {
        }

        @Override
        public SnapshotReader copyFrom(String uri, SnapshotCopierOptions opts) {
            throw new UnsupportedOperationException("Synchronous snapshot copy is not supported.");
        }

        @Override
        public boolean setFilterBeforeCopyRemote() {
            return false;
        }
    }
}

