/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Sets;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.IHostMemberList;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.membership.proto.Join;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.proto.ClusterMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoSeeder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoSeeder.class);
    private final IMessenger messenger;
    private final Scheduler scheduler;
    private final IHostMemberList memberList;
    private final IHostAddressResolver addressResolver;
    private final Duration joinInterval;
    private final LoadingCache<InetSocketAddress, CompletableFuture<Void>> joiningSeeds;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final Gauge seedNumGauge;
    private volatile Set<HostEndpoint> aliveMembers = new HashSet<HostEndpoint>();
    private volatile Disposable job;

    public AutoSeeder(IMessenger messenger, Scheduler scheduler, IHostMemberList memberList, IHostAddressResolver addressResolver, Duration joinTimeout, Duration joinInterval, String ... tags) {
        this.messenger = messenger;
        this.scheduler = scheduler;
        this.memberList = memberList;
        this.addressResolver = addressResolver;
        this.joinInterval = joinInterval;
        this.joiningSeeds = Caffeine.newBuilder().maximumSize(30L).expireAfterWrite(joinTimeout).removalListener((key, value, cause) -> {
            if (value == null) {
                return;
            }
            if (cause.wasEvicted()) {
                log.debug("Stop trying to join seed address[{}]", key);
                value.completeExceptionally(new UnknownHostException(String.valueOf(key) + " is unreachable"));
            } else if (this.stopped.get()) {
                log.debug("Abort joining seed address[{}]", key);
                value.completeExceptionally(new IllegalStateException("Seeding has stopped"));
            } else {
                log.debug("Join seed address[{}] success", key);
                value.complete(null);
            }
        }).build(k -> new CompletableFuture());
        this.disposables.add(memberList.members().observeOn(scheduler).subscribe(m -> this.clearJoined(m.keySet())));
        this.disposables.add(memberList.members().observeOn(scheduler).subscribe(members -> {
            this.aliveMembers = members.keySet();
        }));
        this.seedNumGauge = Gauge.builder((String)"basecluster.seed.num", () -> this.joiningSeeds.estimatedSize()).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public CompletableFuture<Void> join(Set<InetSocketAddress> seeds) {
        if (this.stopped.get()) {
            return CompletableFuture.failedFuture(new IllegalStateException("Seeder has stopped"));
        }
        HashSet<InetSocketAddress> known = new HashSet<InetSocketAddress>();
        for (HostEndpoint endpoint : this.aliveMembers) {
            InetSocketAddress addr = this.addressResolver.resolve(endpoint);
            if (!seeds.contains(addr)) continue;
            known.add(addr);
        }
        Sets.SetView newSeeds = Sets.difference(seeds, known);
        CompletableFuture[] joinFutures = (CompletableFuture[])this.joiningSeeds.getAll((Iterable)newSeeds).values().toArray(CompletableFuture[]::new);
        this.schedule(0L);
        return CompletableFuture.allOf(joinFutures);
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            this.joiningSeeds.invalidateAll();
            this.disposables.dispose();
            if (this.job != null) {
                this.job.dispose();
            }
            Metrics.globalRegistry.remove((Meter)this.seedNumGauge);
        }
    }

    private void schedule(long delayInMS) {
        if (!this.stopped.get() && this.scheduled.compareAndSet(false, true)) {
            this.job = this.scheduler.scheduleDirect(this::run, delayInMS, TimeUnit.MILLISECONDS);
        }
    }

    private Set<InetSocketAddress> clearJoined(Set<HostEndpoint> endpoints) {
        HashSet knownAddresses = new HashSet();
        HashSet allJoiningSeeds = Sets.newHashSet(this.joiningSeeds.asMap().keySet());
        endpoints.forEach(endpoint -> knownAddresses.add(this.addressResolver.resolve((HostEndpoint)endpoint)));
        this.joiningSeeds.invalidateAll((Iterable)Sets.intersection(knownAddresses, (Set)allJoiningSeeds));
        this.joiningSeeds.cleanUp();
        return Sets.difference((Set)allJoiningSeeds, knownAddresses);
    }

    private void run() {
        Set<InetSocketAddress> toJoinSeeds = this.clearJoined(this.aliveMembers);
        for (InetSocketAddress seedAddr : toJoinSeeds) {
            if (seedAddr.isUnresolved()) {
                seedAddr = new InetSocketAddress(seedAddr.getHostName(), seedAddr.getPort());
                log.debug("Resolving hostname[{}] to {}", (Object)seedAddr.getHostName(), (Object)seedAddr.getAddress().getHostAddress());
                if (seedAddr.isUnresolved()) continue;
            }
            InetSocketAddress finalSeedAddr = seedAddr;
            log.debug("Send join message to address[{}]", (Object)finalSeedAddr);
            this.messenger.send(ClusterMessage.newBuilder().setJoin(Join.newBuilder().setMember(this.memberList.local()).build()).build(), finalSeedAddr, true).whenComplete((v, e) -> {
                if (e != null) {
                    log.warn("failed to send join message to {}, due to {}", (Object)finalSeedAddr, (Object)e.getMessage());
                }
            });
        }
        this.scheduled.set(false);
        if (this.stopped.get()) {
            this.joiningSeeds.invalidateAll();
        } else if (!this.joiningSeeds.asMap().isEmpty()) {
            this.schedule(this.joinInterval.toMillis());
        }
    }
}

