/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.protobuf.Struct;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.bifromq.basekv.balance.BalanceNow;
import org.apache.bifromq.basekv.balance.BalanceResult;
import org.apache.bifromq.basekv.balance.NoNeedBalance;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.util.CommandUtil;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.DescriptorUtil;
import org.apache.bifromq.basekv.utils.EffectiveEpoch;
import org.apache.bifromq.basekv.utils.EffectiveRoute;

public abstract class RuleBasedPlacementBalancer
extends StoreBalancer {
    private final AtomicReference<BalanceCommand> balanceCommandHolder = new AtomicReference();
    private volatile Struct loadRules;

    public RuleBasedPlacementBalancer(String clusterId, String localStoreId) {
        super(clusterId, localStoreId);
    }

    public void update(Struct loadRules) {
        this.loadRules = loadRules;
        this.log.debug("Update load rules: {}", (Object)loadRules);
    }

    public final void update(Set<KVRangeStoreDescriptor> landscape) {
        this.log.trace("Update landscape: {}", landscape);
        if (this.loadRules != null) {
            this.update(this.loadRules, landscape);
        } else {
            Struct defaultLoadRules = this.initialLoadRules();
            if (defaultLoadRules != null) {
                this.update(defaultLoadRules, landscape);
            }
        }
    }

    private void update(Struct loadRules, Set<KVRangeStoreDescriptor> landscape) {
        if (loadRules.getFieldsMap().isEmpty()) {
            this.balanceCommandHolder.set(null);
            return;
        }
        Optional effectiveEpoch = DescriptorUtil.getEffectiveEpoch(landscape);
        if (effectiveEpoch.isEmpty()) {
            this.balanceCommandHolder.set(null);
            return;
        }
        EffectiveRoute effectiveRoute = DescriptorUtil.getEffectiveRoute((EffectiveEpoch)((EffectiveEpoch)effectiveEpoch.get()));
        if (!BoundaryUtil.isValidSplitSet(effectiveRoute.leaderRanges().keySet())) {
            this.balanceCommandHolder.set(null);
            return;
        }
        Optional<NavigableMap<Boundary, ClusterConfig>> expectedRoute = this.generate(loadRules, ((EffectiveEpoch)effectiveEpoch.get()).storeDescriptors(), effectiveRoute);
        if (expectedRoute.isEmpty()) {
            this.balanceCommandHolder.set(null);
            return;
        }
        if (!BoundaryUtil.isValidSplitSet(expectedRoute.get().keySet())) {
            this.log.warn("Invalid expected range layout: {}", expectedRoute.get());
            this.balanceCommandHolder.set(null);
            return;
        }
        this.balanceCommandHolder.set(CommandUtil.diffBy(expectedRoute.get(), (EffectiveRoute)effectiveRoute));
    }

    public final BalanceResult balance() {
        BalanceCommand command = this.balanceCommandHolder.get();
        if (command == null || !command.getToStore().equals(this.localStoreId)) {
            return NoNeedBalance.INSTANCE;
        }
        return BalanceNow.of((BalanceCommand)command);
    }

    public abstract boolean validate(Struct var1);

    protected abstract Map<Boundary, ClusterConfig> doGenerate(Struct var1, Map<String, KVRangeStoreDescriptor> var2, EffectiveRoute var3);

    private Optional<NavigableMap<Boundary, ClusterConfig>> generate(Struct loadRules, Set<KVRangeStoreDescriptor> landscape, EffectiveRoute effectiveRoute) {
        try {
            Map<String, KVRangeStoreDescriptor> landscapeMap = landscape.stream().collect(Collectors.toMap(KVRangeStoreDescriptor::getId, store -> store));
            Map<Boundary, ClusterConfig> rangeLayout = this.doGenerate(loadRules, landscapeMap, effectiveRoute);
            if (rangeLayout.isEmpty()) {
                return Optional.empty();
            }
            if (!this.verify(rangeLayout, landscape)) {
                throw new IllegalStateException("Invalid range layout");
            }
            TreeMap<Boundary, ClusterConfig> sortedRangeLayout = new TreeMap<Boundary, ClusterConfig>(BoundaryUtil::compare);
            sortedRangeLayout.putAll(rangeLayout);
            return Optional.of(sortedRangeLayout);
        }
        catch (Throwable e) {
            this.log.error("Balancer[{}] failed to generate range layout from load rules: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), loadRules, e});
            return Optional.empty();
        }
    }

    @VisibleForTesting
    boolean verify(Map<Boundary, ClusterConfig> rangeLayout, Set<KVRangeStoreDescriptor> landscape) {
        if (rangeLayout.keySet().stream().anyMatch(b -> !BoundaryUtil.isNonEmptyRange((Boundary)b))) {
            this.log.error("Balancer[{}] generated empty boundary in range layout: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), rangeLayout);
            return false;
        }
        if (!BoundaryUtil.isValidSplitSet(rangeLayout.keySet())) {
            this.log.error("Balancer[{}] generated invalid boundary found in range layout: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), rangeLayout);
            return false;
        }
        Set storeIds = landscape.stream().map(KVRangeStoreDescriptor::getId).collect(Collectors.toSet());
        for (ClusterConfig clusterConfig : rangeLayout.values()) {
            if (this.isValidClusterConfig(clusterConfig) && storeIds.containsAll((Collection<?>)clusterConfig.getVotersList()) && storeIds.containsAll((Collection<?>)clusterConfig.getLearnersList()) && storeIds.containsAll((Collection<?>)clusterConfig.getNextVotersList()) && storeIds.containsAll((Collection<?>)clusterConfig.getNextLearnersList())) continue;
            this.log.error("Balancer[{}] generated invalid cluster config found in range layout: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), rangeLayout);
            return false;
        }
        return true;
    }

    private boolean isValidClusterConfig(ClusterConfig clusterConfig) {
        if (clusterConfig.equals((Object)ClusterConfig.getDefaultInstance())) {
            return false;
        }
        if (clusterConfig.getVotersList().isEmpty()) {
            return false;
        }
        return Sets.intersection((Set)Sets.newHashSet((Iterable)clusterConfig.getVotersList()), (Set)Sets.newHashSet((Iterable)clusterConfig.getLearnersList())).isEmpty() && Sets.intersection((Set)Sets.newHashSet((Iterable)clusterConfig.getNextVotersList()), (Set)Sets.newHashSet((Iterable)clusterConfig.getNextLearnersList())).isEmpty();
    }
}

