/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.Objects;

class HRWRouter<T> {
    private static final long IEEE754_DOUBLE_1 = 0x3FF0000000000000L;
    private final Collection<T> nodes;
    private final KeyFunction<T> keyFunction;
    private final WeightFunction<T> weightFunction;
    private final HashFunction hashFunction;

    HRWRouter(Collection<T> nodes, KeyFunction<T> keyFunction, WeightFunction<T> weightFunction) {
        this(nodes, keyFunction, weightFunction, key -> {
            HashCode code = Hashing.murmur3_128().hashString((CharSequence)key, Charsets.UTF_8);
            return code.asLong();
        });
    }

    HRWRouter(Collection<T> nodes, KeyFunction<T> keyFunction, WeightFunction<T> weightFunction, HashFunction hashFunction) {
        this.nodes = Objects.requireNonNull(nodes);
        this.keyFunction = Objects.requireNonNull(keyFunction);
        this.weightFunction = Objects.requireNonNull(weightFunction);
        this.hashFunction = Objects.requireNonNull(hashFunction);
    }

    private static double hashToUnitInterval(long x) {
        double u = Double.longBitsToDouble(x >>> 12 | 0x3FF0000000000000L) - 1.0;
        double eps = 1.0E-12;
        if (u <= 0.0) {
            u = 1.0E-12;
        }
        if (u >= 1.0) {
            u = 0.999999999999;
        }
        return u;
    }

    T routeNode(String objectKey) {
        if (this.nodes.isEmpty()) {
            return null;
        }
        T bestNode = null;
        double bestScore = Double.POSITIVE_INFINITY;
        for (T n : this.nodes) {
            long h;
            double u;
            double score;
            String key = this.keyFunction.getKey(n);
            int w = this.weightFunction.getWeight(n);
            if (w <= 0 || !((score = -Math.log(u = HRWRouter.hashToUnitInterval(h = this.hashFunction.hash64(objectKey + key))) / (double)w) < bestScore)) continue;
            bestScore = score;
            bestNode = n;
        }
        return bestNode;
    }

    static interface HashFunction {
        public long hash64(String var1);
    }

    static interface KeyFunction<T> {
        public String getKey(T var1);
    }

    static interface WeightFunction<T> {
        public int getWeight(T var1);
    }
}

