/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.metrics;

import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.metrics.IRPCMeter;
import org.apache.bifromq.baserpc.metrics.RPCMethodMeter;

public class RPCMeter
implements IRPCMeter {
    private final Map<String, IRPCMeter.IRPCMethodMeter> meterMap = new HashMap<String, IRPCMeter.IRPCMethodMeter>();

    public RPCMeter(ServiceDescriptor serviceDescriptor, BluePrint bluePrint) {
        for (MethodDescriptor methodDesc : serviceDescriptor.getMethods()) {
            String serviceName = serviceDescriptor.getName();
            BluePrint.MethodSemantic semantic = bluePrint.semantic(methodDesc.getFullMethodName());
            if (semantic == null) continue;
            this.meterMap.put(methodDesc.getFullMethodName(), new RPCMethodMeter(serviceName, methodDesc, semantic));
        }
    }

    @Override
    public IRPCMeter.IRPCMethodMeter get(MethodDescriptor<?, ?> methodDescriptor) {
        return this.meterMap.get(methodDescriptor.getFullMethodName());
    }
}

