/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.aws.s3.signer.S3V4RestSignerClient;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3V4RestSignerClient.Key", generator="Immutables")
@Immutable
final class ImmutableKey
implements S3V4RestSignerClient.Key {
    private final String method;
    private final String region;
    private final String uri;

    private ImmutableKey(String method, String region, String uri) {
        this.method = method;
        this.region = region;
        this.uri = uri;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String region() {
        return this.region;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public final ImmutableKey withMethod(String value) {
        String newValue = Objects.requireNonNull(value, "method");
        if (this.method.equals(newValue)) {
            return this;
        }
        return new ImmutableKey(newValue, this.region, this.uri);
    }

    public final ImmutableKey withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (this.region.equals(newValue)) {
            return this;
        }
        return new ImmutableKey(this.method, newValue, this.uri);
    }

    public final ImmutableKey withUri(String value) {
        String newValue = Objects.requireNonNull(value, "uri");
        if (this.uri.equals(newValue)) {
            return this;
        }
        return new ImmutableKey(this.method, this.region, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKey && this.equalTo(0, (ImmutableKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableKey another) {
        return this.method.equals(another.method) && this.region.equals(another.region) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.method.hashCode();
        h += (h << 5) + this.region.hashCode();
        h += (h << 5) + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return "Key{method=" + this.method + ", region=" + this.region + ", uri=" + this.uri + "}";
    }

    public static ImmutableKey copyOf(S3V4RestSignerClient.Key instance) {
        if (instance instanceof ImmutableKey) {
            return (ImmutableKey)instance;
        }
        return ImmutableKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="S3V4RestSignerClient.Key", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METHOD = 1L;
        private static final long INIT_BIT_REGION = 2L;
        private static final long INIT_BIT_URI = 4L;
        private long initBits = 7L;
        @Nullable
        private String method;
        @Nullable
        private String region;
        @Nullable
        private String uri;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3V4RestSignerClient.Key instance) {
            Objects.requireNonNull(instance, "instance");
            this.method(instance.method());
            this.region(instance.region());
            this.uri(instance.uri());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder method(String method) {
            this.method = Objects.requireNonNull(method, "method");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKey(this.method, this.region, this.uri);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("method");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("region");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uri");
            }
            return "Cannot build Key, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

