/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.write.confignode.UpdateClusterIdPlan;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterInfo.class);
    private String clusterId = null;
    private static final String SNAPSHOT_FILENAME = "cluster_info.bin";

    public String getClusterId() {
        return this.clusterId;
    }

    public TSStatus updateClusterId(UpdateClusterIdPlan updateClusterIdPlan) {
        this.clusterId = updateClusterIdPlan.getClusterId();
        LOGGER.info("clusterID has been generated: {}", (Object)this.clusterId);
        return RpcUtils.SUCCESS_STATUS;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);){
            boolean bl;
            try (TIOStreamTransport tioStreamTransport = new TIOStreamTransport((OutputStream)fileOutputStream);){
                ReadWriteIOUtils.write((String)this.clusterId, (OutputStream)fileOutputStream);
                tioStreamTransport.flush();
                fileOutputStream.getFD().sync();
                tioStreamTransport.close();
                bl = tmpFile.renameTo(snapshotFile);
            }
            return bl;
        }
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.clusterId = ReadWriteIOUtils.readString((InputStream)fileInputStream);
        }
        LOGGER.info("clusterID has been recovered from snapshot: {}", (Object)this.clusterId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo clusterInfo = (ClusterInfo)o;
        return this.clusterId.equals(clusterInfo.getClusterId());
    }

    public int hashCode() {
        return Objects.hashCode(this.clusterId);
    }
}

