/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.stage;

import java.util.function.Supplier;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.stage.PipeTaskStage;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskSinkRuntimeEnvironment;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSinkSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtaskManager;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeTaskSinkStage
extends PipeTaskStage {
    protected final String pipeName;
    protected final long creationTime;
    protected final PipeParameters pipeConnectorParameters;
    protected final int regionId;
    protected final Supplier<? extends PipeSinkSubtaskExecutor> executor;
    protected String connectorSubtaskId;

    public PipeTaskSinkStage(String pipeName, long creationTime, PipeParameters pipeConnectorParameters, int regionId, Supplier<? extends PipeSinkSubtaskExecutor> executor) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.pipeConnectorParameters = pipeConnectorParameters;
        this.regionId = regionId;
        this.executor = executor;
        this.registerSubtask();
    }

    protected void registerSubtask() {
        this.connectorSubtaskId = PipeSinkSubtaskManager.instance().register(this.executor, this.pipeConnectorParameters, new PipeTaskSinkRuntimeEnvironment(this.pipeName, this.creationTime, this.regionId));
    }

    public void createSubtask() throws PipeException {
    }

    public void startSubtask() throws PipeException {
        PipeSinkSubtaskManager.instance().start(this.connectorSubtaskId);
    }

    public void stopSubtask() throws PipeException {
        PipeSinkSubtaskManager.instance().stop(this.connectorSubtaskId);
    }

    public void dropSubtask() throws PipeException {
        PipeSinkSubtaskManager.instance().deregister(this.pipeName, this.creationTime, this.regionId, this.connectorSubtaskId);
    }

    public UnboundedBlockingPendingQueue<Event> getPipeConnectorPendingQueue() {
        return PipeSinkSubtaskManager.instance().getPipeConnectorPendingQueue(this.connectorSubtaskId);
    }
}

