/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.incubator.codec.http3.Http3DataFrame;
import io.netty.incubator.codec.http3.Http3HeadersFrame;
import io.netty.incubator.codec.quic.QuicChannel;
import java.util.function.Function;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerInfos;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogArgProviderH3;
import reactor.netty.http.server.logging.BaseAccessLogHandler;
import reactor.util.annotation.Nullable;

final class AccessLogHandlerH3
extends BaseAccessLogHandler {
    AccessLogArgProviderH3 accessLogArgProvider;

    AccessLogHandlerH3(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        super(accessLog);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http3HeadersFrame) {
            Http3HeadersFrame requestHeaders = (Http3HeadersFrame)msg;
            if (this.accessLogArgProvider == null) {
                this.accessLogArgProvider = new AccessLogArgProviderH3(ctx.channel().parent() instanceof QuicChannel ? ((QuicChannel)ctx.channel().parent()).remoteSocketAddress() : null);
            }
            this.accessLogArgProvider.requestHeaders(requestHeaders);
            ctx.channel().closeFuture().addListener(f -> {
                AccessLog log = (AccessLog)this.accessLog.apply(this.accessLogArgProvider);
                if (log != null) {
                    log.log();
                }
                this.accessLogArgProvider.clear();
            });
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Http3HeadersFrame) {
            Http3HeadersFrame responseHeaders = (Http3HeadersFrame)msg;
            if (HttpResponseStatus.CONTINUE.codeAsText().contentEquals(responseHeaders.headers().status())) {
                ctx.write(msg, promise);
                return;
            }
            this.accessLogArgProvider.responseHeaders(responseHeaders).chunked(true);
            ChannelOperations ops = ChannelOperations.get((Channel)ctx.channel());
            if (ops instanceof HttpServerInfos) {
                AccessLogHandlerH3.applyServerInfos(this.accessLogArgProvider, (HttpServerInfos)ops);
            }
        }
        if (msg instanceof Http3DataFrame) {
            Http3DataFrame data = (Http3DataFrame)msg;
            this.accessLogArgProvider.increaseContentLength(data.content().readableBytes());
        }
        ctx.write(msg, promise);
    }
}

