/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;

public class WithExclusionIoTDBPipePattern
extends IoTDBPipePatternOperations {
    private final IoTDBPipePatternOperations inclusionPattern;
    private final IoTDBPipePatternOperations exclusionPattern;

    public WithExclusionIoTDBPipePattern(IoTDBPipePatternOperations inclusionPattern, IoTDBPipePatternOperations exclusionPattern) {
        this.inclusionPattern = inclusionPattern;
        this.exclusionPattern = exclusionPattern;
        PipePattern.checkAndLogPatternCoverage(inclusionPattern, exclusionPattern);
    }

    @Override
    public String getPattern() {
        return "INCLUSION(" + this.inclusionPattern.getPattern() + "), EXCLUSION(" + this.exclusionPattern.getPattern() + ")";
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isLegal() {
        return this.inclusionPattern.isLegal() && this.exclusionPattern.isLegal();
    }

    @Override
    public boolean coversDb(String db) {
        return this.inclusionPattern.coversDb(db) && !this.exclusionPattern.mayOverlapWithDb(db);
    }

    @Override
    public boolean coversDevice(String device) {
        return this.inclusionPattern.coversDevice(device) && !this.exclusionPattern.mayOverlapWithDevice(device);
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        return this.inclusionPattern.mayOverlapWithDb(db) && !this.exclusionPattern.coversDb(db);
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        return this.inclusionPattern.mayOverlapWithDevice(device) && !this.exclusionPattern.coversDevice(device);
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        return this.inclusionPattern.matchesMeasurement(device, measurement) && !this.exclusionPattern.matchesMeasurement(device, measurement);
    }

    @Override
    public List<PartialPath> getBaseInclusionPaths() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean matchPrefixPath(String path) {
        return this.inclusionPattern.matchPrefixPath(path) && !this.exclusionPattern.matchPrefixPath(path);
    }

    @Override
    public boolean matchDevice(String devicePath) {
        return this.inclusionPattern.matchDevice(devicePath) && !this.exclusionPattern.matchDevice(devicePath);
    }

    @Override
    public boolean matchTailNode(String tailNode) {
        return this.inclusionPattern.matchTailNode(tailNode) && !this.exclusionPattern.matchTailNode(tailNode);
    }

    @Override
    public List<PartialPath> getIntersection(PartialPath partialPath) {
        List<PartialPath> inclusionIntersections = this.inclusionPattern.getIntersection(partialPath);
        if (inclusionIntersections.isEmpty()) {
            return Collections.emptyList();
        }
        List<PartialPath> exclusionIntersections = this.exclusionPattern.getIntersection(partialPath);
        if (exclusionIntersections.isEmpty()) {
            return inclusionIntersections;
        }
        return inclusionIntersections.stream().filter(incPath -> exclusionIntersections.stream().noneMatch(excPath -> excPath.include((PartialPath)incPath))).collect(Collectors.toList());
    }

    @Override
    public PathPatternTree getIntersection(PathPatternTree patternTree) {
        PathPatternTree inclusionIntersectionTree = this.inclusionPattern.getIntersection(patternTree);
        if (inclusionIntersectionTree.isEmpty()) {
            return inclusionIntersectionTree;
        }
        PathPatternTree exclusionIntersectionTree = this.exclusionPattern.getIntersection(patternTree);
        if (exclusionIntersectionTree.isEmpty()) {
            return inclusionIntersectionTree;
        }
        List<PartialPath> inclusionPaths = inclusionIntersectionTree.getAllPathPatterns();
        List<PartialPath> exclusionPaths = exclusionIntersectionTree.getAllPathPatterns();
        PathPatternTree finalResultTree = new PathPatternTree();
        for (PartialPath incPath : inclusionPaths) {
            boolean excluded = exclusionPaths.stream().anyMatch(excPath -> excPath.include(incPath));
            if (excluded) continue;
            finalResultTree.appendPathPattern(incPath);
        }
        finalResultTree.constructTree();
        return finalResultTree;
    }

    @Override
    public boolean isPrefixOrFullPath() {
        return this.inclusionPattern.isPrefixOrFullPath() && this.exclusionPattern.isPrefixOrFullPath();
    }

    @Override
    public boolean mayMatchMultipleTimeSeriesInOneDevice() {
        return this.inclusionPattern.mayMatchMultipleTimeSeriesInOneDevice();
    }

    public String toString() {
        return "ExclusionIoTDBPipePattern{inclusionPattern=" + this.inclusionPattern + ", exclusionPattern=" + this.exclusionPattern + '}';
    }
}

