/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.sametype.numeric;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Map;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.IntermediateResultOperator;
import org.apache.iotdb.pipe.api.type.Binary;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class AbstractSameTypeNumericOperator
implements IntermediateResultOperator {
    protected TSDataType outPutDataType;
    protected int intValue;
    protected long longValue;
    protected float floatValue;
    protected double doubleValue;

    @Override
    public void configureSystemParameters(Map<String, String> systemParams) {
    }

    @Override
    public boolean initAndGetIsSupport(boolean initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public boolean initAndGetIsSupport(int initialInput, long initialTimestamp) {
        this.outPutDataType = TSDataType.INT32;
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(LocalDate initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public boolean initAndGetIsSupport(long initialInput, long initialTimestamp) {
        this.outPutDataType = TSDataType.INT64;
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(float initialInput, long initialTimestamp) {
        this.outPutDataType = TSDataType.FLOAT;
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(double initialInput, long initialTimestamp) {
        this.outPutDataType = TSDataType.DOUBLE;
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(String initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public boolean initAndGetIsSupport(Binary initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public void updateValue(boolean input, long timestamp) {
        throw new UnsupportedOperationException("AbstractSameTypeNumericOperator does not support boolean input");
    }

    @Override
    public void updateValue(LocalDate input, long timestamp) {
        throw new UnsupportedOperationException("AbstractSameTypeNumericOperator does not support date input");
    }

    @Override
    public void updateValue(String input, long timestamp) {
        throw new UnsupportedOperationException("AbstractSameTypeNumericOperator does not support string input");
    }

    @Override
    public void updateValue(Binary input, long timestamp) {
        throw new UnsupportedOperationException("AbstractSameTypeNumericOperator does not support binary input");
    }

    @Override
    public Pair<TSDataType, Object> getResult() {
        switch (this.outPutDataType) {
            case INT32: {
                return new Pair((Object)TSDataType.INT32, (Object)this.intValue);
            }
            case INT64: {
                return new Pair((Object)TSDataType.INT64, (Object)this.longValue);
            }
            case FLOAT: {
                return new Pair((Object)TSDataType.FLOAT, (Object)Float.valueOf(this.floatValue));
            }
            case DOUBLE: {
                return new Pair((Object)TSDataType.DOUBLE, (Object)this.doubleValue);
            }
        }
        return null;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        this.outPutDataType.serializeTo(outputStream);
        switch (this.outPutDataType) {
            case INT32: {
                ReadWriteIOUtils.write((int)this.intValue, (OutputStream)outputStream);
                break;
            }
            case INT64: {
                ReadWriteIOUtils.write((long)this.longValue, (OutputStream)outputStream);
                break;
            }
            case FLOAT: {
                ReadWriteIOUtils.write((float)this.floatValue, (OutputStream)outputStream);
                break;
            }
            case DOUBLE: {
                ReadWriteIOUtils.write((double)this.doubleValue, (OutputStream)outputStream);
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported output datatype %s", this.outPutDataType));
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) throws IOException {
        this.outPutDataType = TSDataType.deserializeFrom((ByteBuffer)byteBuffer);
        switch (this.outPutDataType) {
            case INT32: {
                this.intValue = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
                break;
            }
            case INT64: {
                this.longValue = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
                break;
            }
            case FLOAT: {
                this.floatValue = ReadWriteIOUtils.readFloat((ByteBuffer)byteBuffer);
                break;
            }
            case DOUBLE: {
                this.doubleValue = ReadWriteIOUtils.readDouble((ByteBuffer)byteBuffer);
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported output datatype %s", this.outPutDataType));
            }
        }
    }
}

