/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ratis.thirdparty.com.google.common.net.InetAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NetUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);
    public static final String LOCALHOST = "localhost";

    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr(target, -1);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort) {
        URI uri;
        boolean hasScheme = (target = Objects.requireNonNull(target, "target == null").trim()).contains("://");
        if (!hasScheme && target.charAt(0) == '/') {
            target = target.substring(1);
        }
        try {
            uri = new URI(hasScheme ? target : "dummy://" + target);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to create URI from target " + target, e);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = defaultPort;
        }
        String path = uri.getPath();
        if (host == null) {
            throw new IllegalArgumentException("Host is null in " + target);
        }
        if (port < 0) {
            throw new IllegalArgumentException("Port = " + port + " < 0 in " + target);
        }
        if (!hasScheme && path != null && !path.isEmpty()) {
            throw new IllegalArgumentException("Unexpected path in " + target);
        }
        return NetUtils.createSocketAddrForHost(host, port);
    }

    public static InetSocketAddress createSocketAddrForHost(String host, int port) {
        InetSocketAddress addr;
        String staticHost = StaticResolution.get(host);
        String resolveHost = staticHost != null ? staticHost : host;
        try {
            InetAddress iaddr = InetAddress.getByName(resolveHost);
            if (staticHost != null) {
                iaddr = InetAddress.getByAddress(host, iaddr.getAddress());
            }
            addr = new InetSocketAddress(iaddr, port);
        }
        catch (UnknownHostException e) {
            addr = InetSocketAddress.createUnresolved(host, port);
        }
        return addr;
    }

    @Deprecated
    public static List<InetSocketAddress> createLocalServerAddress(int count) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(count);
        for (int i = 0; i < count; ++i) {
            list.add(new InetSocketAddress(LOCALHOST, NetUtils.getFreePort()));
        }
        return list;
    }

    @Deprecated
    public static InetSocketAddress createLocalServerAddress() {
        return new InetSocketAddress(LOCALHOST, NetUtils.getFreePort());
    }

    public static String address2String(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        String hostName = address.getHostName();
        StringBuilder b = new StringBuilder(hostName);
        if (address.getAddress() instanceof Inet6Address && InetAddresses.isInetAddress((String)hostName) && InetAddresses.forString((String)hostName).getAddress().length == 16) {
            b.insert(0, '[').append(']');
        }
        return b.append(':').append(address.getPort()).toString();
    }

    public static String localhostWithFreePort() {
        return "localhost:" + NetUtils.getFreePort();
    }

    public static int getFreePort() {
        return PortAllocator.getFreePort();
    }

    public static abstract class StaticResolution {
        private static final Map<String, String> HOST_TO_RESOLVED = new ConcurrentHashMap<String, String>();

        public static void put(String host, String resolvedName) {
            HOST_TO_RESOLVED.put(host, resolvedName);
        }

        public static String get(String host) {
            return HOST_TO_RESOLVED.get(host);
        }
    }

    public static final class PortAllocator {
        private static final int MIN_PORT = 15000;
        private static final int MAX_PORT = 32000;
        private static final AtomicInteger NEXT_PORT = new AtomicInteger(15000);

        private PortAllocator() {
        }

        public static synchronized int getFreePort() {
            while (true) {
                int n;
                int port;
                if ((port = NEXT_PORT.getAndIncrement()) > 32000) {
                    NEXT_PORT.set(15000);
                    port = NEXT_PORT.getAndIncrement();
                }
                ServerSocket ignored = new ServerSocket(port);
                try {
                    n = port;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                ignored.close();
                return n;
                break;
            }
        }
    }
}

