/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.iotdb.db.protocol.mqtt.Message;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatter;
import org.apache.iotdb.db.protocol.mqtt.TableMessage;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinePayloadFormatter
implements PayloadFormatter {
    private static final Logger log = LoggerFactory.getLogger(LinePayloadFormatter.class);
    private static final String REGEX = "(?<table>\\w+)(,(?<tags>[^ ]+))?(\\s+(?<attributes>[^ ]+))?\\s+(?<fields>[^ ]+)\\s+(?<timestamp>\\d+)";
    private static final String COMMA = ",";
    private static final String WELL = "#";
    private static final String LINE_BREAK = "\n";
    private static final String EQUAL = "=";
    private static final String TABLE = "table";
    private static final String TAGS = "tags";
    private static final String ATTRIBUTES = "attributes";
    private static final String FIELDS = "fields";
    private static final String TIMESTAMP = "timestamp";
    private static final String NULL = "null";
    private final Pattern pattern = Pattern.compile("(?<table>\\w+)(,(?<tags>[^ ]+))?(\\s+(?<attributes>[^ ]+))?\\s+(?<fields>[^ ]+)\\s+(?<timestamp>\\d+)");

    @Override
    public List<Message> format(String topic, ByteBuf payload) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (payload == null) {
            return messages;
        }
        String txt = payload.toString(StandardCharsets.UTF_8);
        String[] lines = txt.split(LINE_BREAK);
        String database = !topic.contains("/") ? topic : topic.substring(0, topic.indexOf("/"));
        for (String line : lines) {
            if (line.trim().startsWith(WELL)) continue;
            TableMessage message = new TableMessage();
            try {
                Matcher matcher = this.pattern.matcher(line.trim());
                if (!matcher.matches()) {
                    log.warn("Invalid line protocol format ,line is {}", (Object)line);
                    continue;
                }
                message.setDatabase(database);
                message.setTable(matcher.group(TABLE));
                if (!this.setTags(matcher, message)) {
                    log.warn("The tags is error , line is {}", (Object)line);
                    continue;
                }
                if (!this.setAttributes(matcher, message)) {
                    log.warn("The attributes is error , line is {}", (Object)line);
                    continue;
                }
                if (!this.setFields(matcher, message)) {
                    log.warn("The fields is error , line is {}", (Object)line);
                    continue;
                }
                if (!this.setTimestamp(matcher, message)) {
                    log.warn("The timestamp is error , line is {}", (Object)line);
                    continue;
                }
                messages.add(message);
            }
            catch (Exception e) {
                log.warn("The line pattern parsing fails, and the failed line message is {} ,exception is", (Object)line, (Object)e);
            }
        }
        return messages;
    }

    @Override
    @Deprecated
    public List<Message> format(ByteBuf payload) {
        throw new NotImplementedException();
    }

    private boolean setTags(Matcher matcher, TableMessage message) {
        ArrayList<String> tagKeys = new ArrayList<String>();
        ArrayList<Object> tagValues = new ArrayList<Object>();
        String tagsGroup = matcher.group(TAGS);
        if (tagsGroup != null && !tagsGroup.isEmpty()) {
            String[] tagPairs;
            for (String tagPair : tagPairs = tagsGroup.split(COMMA)) {
                String[] keyValue;
                if (tagPair.isEmpty() || (keyValue = tagPair.split(EQUAL)).length != 2 || NULL.equals(keyValue[1])) continue;
                tagKeys.add(keyValue[0]);
                tagValues.add(new Binary[]{new Binary(keyValue[1].getBytes(StandardCharsets.UTF_8))});
            }
        }
        if (!tagKeys.isEmpty() && !tagValues.isEmpty() && tagKeys.size() == tagValues.size()) {
            message.setTagKeys(tagKeys);
            message.setTagValues(tagValues);
            return true;
        }
        return false;
    }

    private boolean setAttributes(Matcher matcher, TableMessage message) {
        ArrayList<String> attributeKeys = new ArrayList<String>();
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        String attributesGroup = matcher.group(ATTRIBUTES);
        if (attributesGroup != null && !attributesGroup.isEmpty()) {
            String[] attributePairs;
            for (String attributePair : attributePairs = attributesGroup.split(COMMA)) {
                String[] keyValue;
                if (attributePair.isEmpty() || (keyValue = attributePair.split(EQUAL)).length != 2 || NULL.equals(keyValue[1])) continue;
                attributeKeys.add(keyValue[0]);
                attributeValues.add(new Binary[]{new Binary(keyValue[1].getBytes(StandardCharsets.UTF_8))});
            }
        }
        if (attributeKeys.size() == attributeValues.size()) {
            message.setAttributeKeys(attributeKeys);
            message.setAttributeValues(attributeValues);
            return true;
        }
        return false;
    }

    private boolean setFields(Matcher matcher, TableMessage message) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<Object> values = new ArrayList<Object>();
        String fieldsGroup = matcher.group(FIELDS);
        if (fieldsGroup != null && !fieldsGroup.isEmpty()) {
            String[] fieldPairs;
            for (String fieldPair : fieldPairs = fieldsGroup.split(COMMA)) {
                String[] keyValue;
                if (fieldPair.isEmpty() || (keyValue = fieldPair.split(EQUAL)).length != 2 || NULL.equals(keyValue[1])) continue;
                fields.add(keyValue[0]);
                Pair<TSDataType, Object> typeAndValue = this.analyticValue(keyValue[1]);
                values.add(typeAndValue.getRight());
                dataTypes.add((TSDataType)typeAndValue.getLeft());
            }
        }
        if (!fields.isEmpty() && !values.isEmpty() && fields.size() == values.size()) {
            message.setFields(fields);
            message.setDataTypes(dataTypes);
            message.setValues(values);
            return true;
        }
        return false;
    }

    private Pair<TSDataType, Object> analyticValue(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return new Pair((Object)TSDataType.TEXT, (Object)new Binary[]{new Binary(value.substring(1, value.length() - 1).getBytes(StandardCharsets.UTF_8))});
        }
        if (value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("f") || value.equalsIgnoreCase("false")) {
            return new Pair((Object)TSDataType.BOOLEAN, (Object)new boolean[]{value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true")});
        }
        if (value.endsWith("f")) {
            return new Pair((Object)TSDataType.FLOAT, (Object)new float[]{Float.parseFloat(value.substring(0, value.length() - 1))});
        }
        if (value.endsWith("i32")) {
            return new Pair((Object)TSDataType.INT32, (Object)new int[]{Integer.parseInt(value.substring(0, value.length() - 3))});
        }
        if (value.endsWith("u") || value.endsWith("i")) {
            return new Pair((Object)TSDataType.INT64, (Object)new long[]{Long.parseLong(value.substring(0, value.length() - 1))});
        }
        return new Pair((Object)TSDataType.DOUBLE, (Object)new double[]{Double.parseDouble(value)});
    }

    private boolean setTimestamp(Matcher matcher, TableMessage message) {
        String timestampGroup = matcher.group(TIMESTAMP);
        if (timestampGroup != null && !timestampGroup.isEmpty()) {
            message.setTimestamp(Long.parseLong(timestampGroup));
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "line";
    }

    @Override
    public String getType() {
        return TABLE;
    }
}

