/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.httpclient5.internal;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class HttpEntityAsyncEntityProducer
implements AsyncEntityProducer {
    private final HttpEntity entity;
    private final ByteBuffer byteBuffer;
    private final boolean chunked;
    private final AtomicReference<Exception> exception;
    private final AtomicReference<ReadableByteChannel> channelRef;
    private boolean eof;

    public HttpEntityAsyncEntityProducer(HttpEntity entity, int bufferSize) {
        this.entity = (HttpEntity)Args.notNull((Object)entity, (String)"Http Entity");
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        this.chunked = entity.isChunked();
        this.exception = new AtomicReference();
        this.channelRef = new AtomicReference();
    }

    public HttpEntityAsyncEntityProducer(HttpEntity entity) {
        this(entity, 8192);
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public String getContentType() {
        return this.entity.getContentType();
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public int available() {
        return Integer.MAX_VALUE;
    }

    public String getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public Set<String> getTrailerNames() {
        return this.entity.getTrailerNames();
    }

    public void produce(DataStreamChannel channel) throws IOException {
        int bytesRead;
        ReadableByteChannel stream = this.channelRef.get();
        if (stream == null) {
            stream = Channels.newChannel(this.entity.getContent());
            Asserts.check((this.channelRef.getAndSet(stream) == null ? 1 : 0) != 0, (String)"Illegal producer state");
        }
        if (!this.eof && (bytesRead = stream.read(this.byteBuffer)) < 0) {
            this.eof = true;
        }
        if (this.byteBuffer.position() > 0) {
            ((Buffer)this.byteBuffer).flip();
            channel.write(this.byteBuffer);
            this.byteBuffer.compact();
        }
        if (this.eof && this.byteBuffer.position() == 0) {
            channel.endStream();
            this.releaseResources();
        }
    }

    public void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public void releaseResources() {
        this.eof = false;
        ReadableByteChannel stream = this.channelRef.getAndSet(null);
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

