/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.ResultsWriter;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;

public class QueryExecUtils {
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();
    protected static Prologue dftPrologue;

    public static void exec(Query query, DatasetGraph dsg) {
        QueryExec qExec = QueryExec.dataset(dsg).query(query).build();
        QueryExecUtils.exec(qExec);
    }

    public static void exec(Query query, Graph graph) {
        QueryExec qExec = QueryExec.graph(graph).query(query).build();
        QueryExecUtils.exec(qExec);
    }

    public static void exec(QueryExec queryExec) {
        QueryExecUtils.exec((Prologue)queryExec.getQuery(), queryExec);
    }

    public static void exec(Prologue prologue, QueryExec queryExec) {
        QueryExecUtils.exec(prologue, queryExec, ResultsFormat.TEXT);
    }

    public static void exec(Prologue prologue, QueryExec queryExec, ResultsFormat outputFormat) {
        QueryExecUtils.exec(prologue, queryExec, outputFormat, System.out);
    }

    public static void exec(Prologue prologue, QueryExec queryExec, ResultsFormat outputFormat, OutputStream output) {
        QueryExecution queryExecution = QueryExecutionAdapter.adapt(queryExec);
        QueryExecUtils.executeQuery(prologue, queryExecution, outputFormat, output);
    }

    public static void executeQuery(QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(null, queryExecution);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(prologue, queryExecution, ResultsFormat.TEXT);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution, ResultsFormat outputFormat) {
        QueryExecUtils.executeQuery(prologue, queryExecution, outputFormat, System.out);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution, ResultsFormat outputFormat, OutputStream output) {
        Query query = queryExecution.getQuery();
        if (prologue == null && query != null) {
            prologue = query.getPrologue();
        }
        if (prologue == null) {
            prologue = dftPrologue;
        }
        if (query.isSelectType()) {
            QueryExecUtils.doSelectQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isDescribeType()) {
            QueryExecUtils.doDescribeQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isConstructQuad()) {
            QueryExecUtils.doConstructQuadsQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isConstructType()) {
            QueryExecUtils.doConstructQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isAskType()) {
            QueryExecUtils.doAskQuery(prologue, queryExecution, outputFormat, output);
        } else if (query.isJsonType()) {
            QueryExecUtils.doJsonQuery(prologue, queryExecution, outputFormat, output);
        } else {
            throw new QueryException("Unrecognized query form");
        }
    }

    public static void execute(Op op, DatasetGraph dsg) {
        QueryExecUtils.execute(op, dsg, ResultsFormat.TEXT);
    }

    public static void execute(Op op, DatasetGraph dsg, ResultsFormat outputFormat) {
        QueryExecUtils.execute(op, dsg, outputFormat, System.out);
    }

    public static void execute(Op op, DatasetGraph dsg, ResultsFormat outputFormat, OutputStream output) {
        QueryIterator qIter = Algebra.exec(op, dsg);
        List<Var> vars = null;
        vars = op instanceof OpProject ? ((OpProject)op).getVars() : new ArrayList<Var>(OpVars.visibleVars(op));
        ResultSet results = ResultSetStream.create(vars, (Iterator<Binding>)((Object)qIter));
        QueryExecUtils.outputResultSet(results, null, outputFormat, output);
    }

    public static void output(SPARQLResult result, ResultsFormat outputFormat, OutputStream output) {
        if (result.isResultSet()) {
            ResultSet rs = result.getResultSet();
            QueryExecUtils.outputResultSet(rs, null, outputFormat, output);
            return;
        }
        if (result.isModel()) {
            Model m = result.getModel();
            QueryExecUtils.writeModel(m, outputFormat, output);
            return;
        }
        if (result.isGraph()) {
            // empty if block
        }
        if (result.isDataset()) {
            QueryExecUtils.writeDataset(result.getDataset(), outputFormat, output);
            return;
        }
        if (result.isJson()) {
            result.getJsonItems();
            return;
        }
    }

    public static void outputResultSet(ResultSet resultSet, Prologue prologue, ResultsFormat outputFormat, OutputStream output) {
        if (prologue == null) {
            prologue = new Prologue(globalPrefixMap);
        }
        if (outputFormat == ResultsFormat.TEXT) {
            ResultSetFormatter.out(output, resultSet, prologue.getPrefixMapping());
            return;
        }
        if (outputFormat == ResultsFormat.COUNT) {
            long count = ResultSetFormatter.consume(resultSet);
            String text = String.format("%d\n", count);
            try (PrintStream ps = new PrintStream(output);){
                ps.print(text);
            }
            return;
        }
        Lang rsLang = outputFormat.resultSetLang();
        if (rsLang == null) {
            RDFFormat asRDF = outputFormat.rdfFormat();
            Model model = RDFOutput.encodeAsModel(resultSet);
            RDFWriter.source(model).format(asRDF).output(output);
            return;
        }
        if (!ResultSetLang.isRegistered(rsLang)) {
            throw QueryExecUtils.noFormatException("Not a result set output lang: " + rsLang.getName());
        }
        Context context2 = ARQ.getContext().copy();
        if (prologue != null) {
            context2.set(ARQConstants.symPrologue, prologue);
        }
        ResultsWriter.create().context(context2).lang(rsLang).build().write(output, resultSet);
    }

    private static void doSelectQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, OutputStream output) {
        if (prologue == null) {
            prologue = qe.getQuery().getPrologue();
        }
        if (outputFormat == null) {
            outputFormat = ResultsFormat.TEXT;
        }
        ResultSet results = qe.execSelect();
        QueryExecUtils.outputResultSet(results, prologue, outputFormat, output);
    }

    private static void doJsonQuery(Prologue prologue, QueryExecution queryExecution, ResultsFormat outputFormat, OutputStream output) {
        JsonArray results = queryExecution.execJson();
        JSON.write(output, (JsonValue)results);
    }

    private static void doDescribeQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, OutputStream output) {
        Model r = qe.execDescribe();
        QueryExecUtils.writeModel(r, outputFormat, output);
    }

    private static void doConstructQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, OutputStream output) {
        if (qe.getQuery().isConstructQuad()) {
            QueryExecUtils.doConstructQuadsQuery(prologue, qe, outputFormat, output);
            return;
        }
        Model r = qe.execConstruct();
        QueryExecUtils.writeModel(r, outputFormat, output);
    }

    private static void doConstructQuadsQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, OutputStream output) {
        Dataset ds = qe.execConstructDataset();
        QueryExecUtils.writeDataset(ds, outputFormat, output);
    }

    private static void doAskQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat, OutputStream output) {
        boolean resultBoolean = qe.execAsk();
        if (outputFormat == ResultsFormat.TEXT) {
            ResultSetFormatter.out(output, resultBoolean);
            return;
        }
        Lang rsLang = outputFormat.resultSetLang();
        if (rsLang == null) {
            RDFFormat asRDF = outputFormat.rdfFormat();
            Model model = RDFOutput.encodeAsModel(resultBoolean);
            RDFWriter.source(model).format(asRDF).output(output);
            return;
        }
        ResultsWriter.create().lang(rsLang).build().write(output, resultBoolean);
    }

    private static void writeModel(Model model, ResultsFormat outputFormat, OutputStream output) {
        RDFFormat rdfFormat = RDFFormat.TURTLE_PRETTY;
        RDFWriter.source(model).format(rdfFormat).output(output);
    }

    private static void writeDataset(Dataset dataset, ResultsFormat outputFormat, OutputStream output) {
        RDFFormat rdfFormat = outputFormat.rdfFormat();
        if (rdfFormat == null) {
            throw QueryExecUtils.noFormatException("No dataset output format for : " + outputFormat.name());
        }
        RDFWriter.source(dataset).format(rdfFormat).output(output);
    }

    private static RuntimeException noFormatException(String msg) {
        return new ARQException(msg);
    }

    public static RDFNode getExactlyOne(String qs, Model model) {
        return QueryExecUtils.getExactlyOne(qs, DatasetFactory.wrap(model));
    }

    public static RDFNode getExactlyOne(String qs, Dataset ds) {
        Query q = QueryFactory.create(qs);
        if (q.getResultVars().size() != 1) {
            throw new ARQException("getExactlyOne: Must have exactly one result columns");
        }
        String varname = q.getResultVars().get(0);
        try (QueryExecution qExec = QueryExecutionFactory.create(q, ds);){
            RDFNode rDFNode = QueryExecUtils.getExactlyOne(qExec, varname);
            return rDFNode;
        }
    }

    public static RDFNode getExactlyOne(QueryExecution qExec, String varname) {
        ResultSet rs = qExec.execSelect();
        if (!rs.hasNext()) {
            throw new ARQException("Not found: var ?" + varname);
        }
        QuerySolution qs = rs.nextSolution();
        RDFNode r = qs.get(varname);
        if (rs.hasNext()) {
            throw new ARQException("More than one: var ?" + varname);
        }
        return r;
    }

    public static RDFNode getAtMostOne(QueryExecution qExec, String varname) {
        ResultSet rs = qExec.execSelect();
        if (!rs.hasNext()) {
            return null;
        }
        QuerySolution qs = rs.nextSolution();
        RDFNode r = qs.get(varname);
        if (rs.hasNext()) {
            QuerySolution qs2 = rs.next();
            RDFNode r2 = qs2.get(varname);
            if (rs.hasNext()) {
                throw new ARQException("More than one: var ?" + varname + " -> " + String.valueOf(r) + ", " + String.valueOf(r2) + ", ...");
            }
            throw new ARQException("Found two matches: var ?" + varname + " -> " + String.valueOf(r) + ", " + String.valueOf(r2));
        }
        return r;
    }

    public static List<RDFNode> getAll(QueryExecution qExec, String varname) {
        ResultSet rs = qExec.execSelect();
        ArrayList<RDFNode> matches = new ArrayList<RDFNode>();
        rs.forEachRemaining((Consumer<? super QuerySolution>)((Consumer<QuerySolution>)qs -> {
            RDFNode r = qs.get(varname);
            if (r != null) {
                matches.add(r);
            }
        }));
        return matches;
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        globalPrefixMap.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        globalPrefixMap.setNsPrefix("ex", "http://example.org/");
        globalPrefixMap.setNsPrefix("ns", "http://example.org/ns#");
        globalPrefixMap.setNsPrefix("", "http://example/");
        dftPrologue = new Prologue(globalPrefixMap);
    }
}

