/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shacl.Imports;
import org.apache.jena.shacl.engine.Targets;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapesParser;
import org.apache.jena.sys.JenaSystem;

public class Shapes
implements Iterable<Shape> {
    private final ShapesParser.ParserResult parserResult;
    private final Graph shapesGraph;
    private final Node shapesBase;
    private final PrefixMap prefixMap;
    private final Map<Node, Shape> shapes;
    private final Collection<Shape> rootShapes;
    private final Collection<Shape> declShapes;
    private final Collection<Shape> otherShapes;
    private final Targets targets;
    private final List<Node> imports;

    public static Shapes parse(Model model) {
        return Shapes.parse(model.getGraph());
    }

    public static Shapes parse(String fileOrURL) {
        Graph g = RDFDataMgr.loadGraph(fileOrURL);
        return Shapes.parse(g);
    }

    public static Shapes parse(String fileOrURL, boolean withImports) {
        Graph g = withImports ? Imports.loadWithImports(fileOrURL) : RDFDataMgr.loadGraph(fileOrURL);
        return Shapes.parse(g);
    }

    public static Shapes parse(Graph graph) {
        return Shapes.parseAll(graph);
    }

    private static Shapes parseAll(Graph graph) {
        Collection<Node> declShapes = ShapesParser.findDeclaredShapes(graph);
        Shapes shapes = Shapes.parseProcess(graph, declShapes);
        return shapes;
    }

    private static Shapes parseProcess(Graph shapesGraph, Collection<Node> declaredNodes) {
        ShapesParser.ParserResult x = ShapesParser.parseProcess(shapesGraph, declaredNodes);
        return new Shapes(shapesGraph, x);
    }

    private Shapes(Graph shapesGraph, ShapesParser.ParserResult x) {
        this.parserResult = x;
        this.shapesGraph = shapesGraph;
        this.prefixMap = Prefixes.adapt(shapesGraph);
        this.targets = x.targets;
        this.shapes = x.shapesMap;
        this.rootShapes = x.rootShapes;
        this.declShapes = x.declaredShapes;
        this.otherShapes = x.otherShapes;
        this.shapesBase = x.shapesBase;
        this.imports = x.imports;
    }

    public boolean isEmpty() {
        return this.shapes.isEmpty();
    }

    public Collection<Shape> getTargetShapes() {
        return this.rootShapes;
    }

    public Collection<Node> getImports() {
        return this.imports;
    }

    public Node getBase() {
        return this.shapesBase;
    }

    public String getBaseURI() {
        if (this.shapesBase == null || !this.shapesBase.isURI()) {
            return null;
        }
        return this.shapesBase.getURI();
    }

    public PrefixMap getPrefixMap() {
        return this.prefixMap;
    }

    public Graph getGraph() {
        return this.shapesGraph;
    }

    public Shape getShape(Node node) {
        return this.shapes.get(node);
    }

    public Map<Node, Shape> getShapeMap() {
        return this.shapes;
    }

    public Targets getTargets() {
        return this.targets;
    }

    public int numShapes() {
        return this.shapes.values().size();
    }

    public int numRootShapes() {
        return this.rootShapes.size();
    }

    @Override
    public Iterator<Shape> iterator() {
        return this.rootShapes.iterator();
    }

    public Iterator<Shape> iteratorAll() {
        return Iter.iter(this.rootShapes.iterator()).append(this.declShapes.iterator()).append(this.otherShapes.iterator());
    }

    static {
        JenaSystem.init();
    }
}

