/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.helper;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.ReaderResource;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.svl.VarResolverSession;

public class ResolvingReaderResource
extends ReaderResource {
    private final VarResolverSession varSession;

    protected ResolvingReaderResource(Builder b) throws IOException {
        this(b.mediaType, (Map<String, Object>)b.headers, b.cached, b.varResolver, b.contents.toArray());
    }

    public ResolvingReaderResource(MediaType mediaType, Map<String, Object> headers, boolean cached, VarResolverSession varSession, Object ... contents) throws IOException {
        super(mediaType, headers, cached, contents);
        this.varSession = varSession;
    }

    public static Builder create() {
        return new Builder();
    }

    @Override
    @ResponseBody
    public Writer writeTo(Writer w) throws IOException {
        for (Object o : this.contents) {
            if (o == null) continue;
            if (this.varSession == null) {
                IOUtils.pipe(o, w);
                continue;
            }
            this.varSession.resolveTo(IOUtils.read(o), w);
        }
        return w;
    }

    public static class Builder
    extends ReaderResource.Builder {
        VarResolverSession varResolver;

        public Builder varResolver(VarResolverSession varResolver) {
            this.varResolver = varResolver;
            return this;
        }

        @Override
        public Builder mediaType(String mediaType) {
            super.mediaType(mediaType);
            return this;
        }

        @Override
        public Builder mediaType(MediaType mediaType) {
            super.mediaType(mediaType);
            return this;
        }

        @Override
        public Builder contents(Object ... contents) {
            super.contents(contents);
            return this;
        }

        @Override
        public Builder header(String name, Object value) {
            super.header(name, value);
            return this;
        }

        @Override
        public Builder headers(Map<String, Object> headers) {
            super.headers(headers);
            return this;
        }

        @Override
        public Builder cached() {
            super.cached();
            return this;
        }

        @Override
        public ResolvingReaderResource build() throws IOException {
            return new ResolvingReaderResource(this);
        }
    }
}

