/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.PropertySource;

public class PaxPropertySource
implements PropertySource {
    private static final String PREFIX = "log4j2.";
    public static boolean debug;
    public static String defaultLevel;
    public static String fileConfiguration;
    private static final Map<String, String> properties;

    public PaxPropertySource() {
        properties.put("log4j2.debug", Boolean.toString(debug));
        properties.put("log4j2.enable.threadlocals", Boolean.FALSE.toString());
        properties.put("log4j2.is.webapp", Boolean.FALSE.toString());
        properties.put("log4j2.shutdownHookEnabled", Boolean.FALSE.toString());
        properties.put("log4j2.level", defaultLevel);
        properties.put("log4j2.disableJmx", Boolean.TRUE.toString());
        properties.put("log4j2.skipJansi", Boolean.TRUE.toString());
        if (fileConfiguration != null) {
            properties.put("log4j.configurationFile", fileConfiguration);
        }
    }

    public static void updateFileConfiguration(String fileName) {
        fileConfiguration = fileName;
        properties.put("log4j.configurationFile", fileName);
    }

    @Override
    public int getPriority() {
        return 199;
    }

    @Override
    public Collection<String> getPropertyNames() {
        return properties.keySet();
    }

    @Override
    public String getProperty(String key) {
        return properties.get(key);
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        properties.forEach(action::accept);
    }

    @Override
    public boolean containsProperty(String key) {
        return properties.containsKey(key);
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return PREFIX + String.valueOf(PropertySource.Util.joinAsCamelCase(tokens));
    }

    static {
        defaultLevel = "DEBUG";
        fileConfiguration = null;
        properties = new HashMap<String, String>();
    }
}

