/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.ldaptive.Connection;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.cache.Cache;
import org.ldaptive.handler.OperationExceptionHandler;
import org.ldaptive.handler.OperationResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchExecutor
extends SearchRequest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService service;
    private OperationExceptionHandler<SearchRequest, SearchResult> searchExceptionHandler;
    private OperationResponseHandler<SearchRequest, SearchResult>[] searchResponseHandlers;
    private Cache<SearchRequest> searchCache;

    public AbstractSearchExecutor(ExecutorService es) {
        if (es == null) {
            throw new NullPointerException("ExecutorService cannot be null");
        }
        this.service = es;
    }

    protected ExecutorService getExecutorService() {
        return this.service;
    }

    public OperationExceptionHandler<SearchRequest, SearchResult> getSearchExceptionHandler() {
        return this.searchExceptionHandler;
    }

    public void setSearchExceptionHandler(OperationExceptionHandler<SearchRequest, SearchResult> handler) {
        this.searchExceptionHandler = handler;
    }

    public OperationResponseHandler<SearchRequest, SearchResult>[] getSearchResponseHandlers() {
        return this.searchResponseHandlers;
    }

    public void setSearchResponseHandlers(OperationResponseHandler<SearchRequest, SearchResult> ... handlers) {
        this.searchResponseHandlers = handlers;
    }

    public Cache<SearchRequest> getSearchCache() {
        return this.searchCache;
    }

    public void setSearchCache(Cache<SearchRequest> cache) {
        this.searchCache = cache;
    }

    public void shutdown() {
        this.service.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.service.shutdownNow();
    }

    protected SearchOperation createSearchOperation(Connection conn) {
        SearchOperation op = new SearchOperation(conn);
        if (this.searchExceptionHandler != null) {
            op.setOperationExceptionHandler(this.searchExceptionHandler);
        }
        if (this.searchResponseHandlers != null) {
            op.setOperationResponseHandlers(this.searchResponseHandlers);
        }
        if (this.searchCache != null) {
            op.setCache(this.searchCache);
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::service=%s, searchExceptionHandler=%s, searchResponseHandlers=%s, searchCache=%s]", this.getClass().getName(), this.hashCode(), this.service, this.searchExceptionHandler, Arrays.toString(this.searchResponseHandlers), this.searchCache);
    }
}

