/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.concurrent.AbstractAggregateSearchExecutor;
import org.ldaptive.concurrent.OperationWorker;
import org.ldaptive.concurrent.SearchOperationWorker;
import org.ldaptive.handler.SearchEntryHandler;

public class AggregateSearchExecutor
extends AbstractAggregateSearchExecutor<ConnectionFactory> {
    public AggregateSearchExecutor() {
        this(Executors.newCachedThreadPool());
    }

    public AggregateSearchExecutor(ExecutorService es) {
        super(es);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Response<SearchResult>> search(ConnectionFactory[] factories, SearchFilter[] filters, String[] attrs, SearchEntryHandler ... handlers) throws LdapException {
        void var10_13;
        ExecutorCompletionService searches = new ExecutorCompletionService(this.getExecutorService());
        Request[] requests = new SearchRequest[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            SearchRequest sr = AggregateSearchExecutor.newSearchRequest(this);
            if (filters[i] != null) {
                sr.setSearchFilter(filters[i]);
            }
            if (attrs != null) {
                sr.setReturnAttributes(attrs);
            }
            if (handlers != null) {
                sr.setSearchEntryHandlers(handlers);
            }
            requests[i] = sr;
        }
        ArrayList futures = new ArrayList(factories.length * filters.length);
        ConnectionFactory[] arr$ = factories;
        int len$ = arr$.length;
        boolean bl = false;
        while (var10_13 < len$) {
            ConnectionFactory factory = arr$[var10_13];
            Connection conn = factory.getConnection();
            SearchOperation op = this.createSearchOperation(conn);
            SearchOperationWorker worker = new SearchOperationWorker(op, this.getExecutorService());
            futures.add(searches.submit(AggregateSearchExecutor.createCallable((Connection)conn, (OperationWorker)worker, (Request[])requests)));
            ++var10_13;
        }
        ArrayList<Response<SearchResult>> responses = new ArrayList<Response<SearchResult>>(factories.length * filters.length);
        for (Future future : futures) {
            try {
                responses.addAll((Collection)future.get());
            }
            catch (ExecutionException e) {
                this.logger.debug("ExecutionException thrown, ignoring", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.warn("InterruptedException thrown, ignoring", (Throwable)e);
            }
        }
        return responses;
    }

    protected static <Q extends Request, S> Callable<Collection<Response<S>>> createCallable(final Connection conn, final OperationWorker<Q, S> worker, Q[] requests) {
        return new Callable<Collection<Response<S>>>((Request[])requests){
            final /* synthetic */ Request[] val$requests;
            {
                this.val$requests = requestArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<Response<S>> call() throws LdapException {
                try {
                    conn.open();
                    Collection collection = worker.executeToCompletion(this.val$requests);
                    return collection;
                }
                finally {
                    conn.close();
                }
            }
        };
    }
}

