/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.fips;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class BCInterceptingOutputStream
extends OutputStream {
    private static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    private final OutputStream delegate;
    private static final String BOUNCYCASTLE_TLS_PROTOCOL_NAME = "org.bouncycastle.tls.TlsProtocol";
    private static final String BOUNCYCASTLE_HANDLE_CLOSE_METHOD = "handleClose";
    private static final String BROKEN_PIPE_MESSAGE = "Broken pipe";

    public BCInterceptingOutputStream(OutputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.delegate.write(b);
        }
        catch (SocketException e) {
            this.handleSocketException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.delegate.write(b);
        }
        catch (SocketException e) {
            this.handleSocketException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.delegate.write(b, off, len);
        }
        catch (SocketException e) {
            this.handleSocketException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private void handleSocketException(SocketException socketException) throws SocketException {
        boolean exceptionIgnored = false;
        if (socketException.getMessage() != null && StringUtils.containsIgnoreCase((CharSequence)socketException.getMessage(), (CharSequence)BROKEN_PIPE_MESSAGE)) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement ste : stackTrace = socketException.getStackTrace()) {
                if (!BOUNCYCASTLE_TLS_PROTOCOL_NAME.equals(ste.getClassName()) || !BOUNCYCASTLE_HANDLE_CLOSE_METHOD.equals(ste.getMethodName())) continue;
                LOG.ignoreHandleCloseError();
                exceptionIgnored = true;
            }
        }
        if (!exceptionIgnored) {
            throw socketException;
        }
    }
}

