/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class AmbariComponent {
    private String clusterName;
    private String serviceName;
    private String name;
    private String version;
    private List<String> hostNames = new ArrayList<String>();
    private Map<String, String> properties;

    AmbariComponent(String name, String version, String cluster, String service, List<String> hostNames, Map<String, String> properties) {
        this.name = name;
        this.serviceName = service;
        this.clusterName = cluster;
        this.version = version;
        this.properties = properties;
        if (hostNames != null) {
            for (String hostName : hostNames) {
                if (hostName == null) continue;
                this.hostNames.add(hostName);
            }
        }
    }

    String getVersion() {
        return this.version;
    }

    String getName() {
        return this.name;
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getClusterName() {
        return this.clusterName;
    }

    List<String> getHostNames() {
        return this.hostNames;
    }

    Map<String, String> getConfigProperties() {
        return this.properties;
    }

    String getConfigProperty(String propertyName) {
        return this.properties.get(propertyName);
    }
}

