/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.Toolchain;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.ToolchainFactory;
import org.apache.maven.api.services.ToolchainFactoryException;
import org.apache.maven.api.services.ToolchainManager;
import org.apache.maven.api.services.ToolchainManagerException;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultToolchainManager
implements ToolchainManager {
    private final Map<String, ToolchainFactory> factories;
    private final Logger logger;
    private static final SessionData.Key<ConcurrentHashMap<Project, ConcurrentHashMap<String, Object>>> TOOLCHAIN_CONTEXT_KEY = SessionData.key(ConcurrentHashMap.class, (Object)"toolchain-context");

    @Inject
    public DefaultToolchainManager(Map<String, ToolchainFactory> factories) {
        this(factories, null);
    }

    protected DefaultToolchainManager(Map<String, ToolchainFactory> factories, Logger logger) {
        this.factories = factories;
        this.logger = logger != null ? logger : LoggerFactory.getLogger(DefaultToolchainManager.class);
    }

    @Nonnull
    public List<Toolchain> getToolchains(@Nonnull Session session, @Nonnull String type, @Nullable Map<String, String> requirements) throws ToolchainManagerException {
        ToolchainFactory factory = this.factories.get(Objects.requireNonNull(type, "type"));
        if (factory == null) {
            this.logger.error("Missing toolchain factory for type: " + type + ". Possibly caused by misconfigured project.");
            return List.of();
        }
        return Stream.concat(session.getToolchains().stream().filter(model -> Objects.equals(type, model.getType())).map(this::createToolchain).flatMap(Optional::stream), factory.createDefaultToolchain().stream()).filter(toolchain -> requirements == null || toolchain.matchesRequirements(requirements)).toList();
    }

    @Nonnull
    public Optional<Toolchain> getToolchainFromBuildContext(@Nonnull Session session, @Nonnull String type) throws ToolchainManagerException {
        Map<String, Object> context = this.retrieveContext(session);
        ToolchainModel model = (ToolchainModel)context.get("toolchain-" + type);
        return Optional.ofNullable(model).flatMap(this::createToolchain);
    }

    public void storeToolchainToBuildContext(@Nonnull Session session, @Nonnull Toolchain toolchain) {
        Map<String, Object> context = this.retrieveContext(session);
        context.put("toolchain-" + toolchain.getType(), toolchain.getModel());
    }

    private Optional<Toolchain> createToolchain(ToolchainModel model) {
        String type = Objects.requireNonNull(model.getType(), "model.getType()");
        ToolchainFactory factory = this.factories.get(type);
        if (factory != null) {
            try {
                return Optional.of(factory.createToolchain(model));
            }
            catch (ToolchainFactoryException e) {
                throw new ToolchainManagerException("Error creating toolchain of type " + type, (Exception)((Object)e));
            }
        }
        this.logger.error("Missing toolchain factory for type: " + type + ". Possibly caused by misconfigured project.");
        return Optional.empty();
    }

    protected Map<String, Object> retrieveContext(Session session) {
        Optional current = ((Lookup)session.getService(Lookup.class)).lookupOptional(Project.class);
        if (current.isPresent()) {
            ConcurrentHashMap map = (ConcurrentHashMap)session.getData().computeIfAbsent(TOOLCHAIN_CONTEXT_KEY, ConcurrentHashMap::new);
            return map.computeIfAbsent((Project)current.get(), p -> new ConcurrentHashMap());
        }
        return new HashMap<String, Object>();
    }
}

