/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.c2.protocol.component.api.Attribute;
import org.apache.nifi.c2.protocol.component.api.ConfigurableExtensionDefinition;
import org.apache.nifi.c2.protocol.component.api.DynamicRelationship;
import org.apache.nifi.c2.protocol.component.api.MultiProcessorUseCase;
import org.apache.nifi.c2.protocol.component.api.Relationship;
import org.apache.nifi.c2.protocol.component.api.UseCase;

public class ProcessorDefinition
extends ConfigurableExtensionDefinition {
    private static final long serialVersionUID = 1L;
    private InputRequirement.Requirement inputRequirement;
    private List<Relationship> supportedRelationships;
    private boolean supportsDynamicRelationships;
    private DynamicRelationship dynamicRelationship;
    private boolean triggerSerially;
    private boolean triggerWhenEmpty;
    private boolean triggerWhenAnyDestinationAvailable;
    private boolean supportsBatching;
    private boolean primaryNodeOnly;
    private boolean sideEffectFree;
    private List<String> supportedSchedulingStrategies;
    private String defaultSchedulingStrategy;
    private Map<String, Integer> defaultConcurrentTasksBySchedulingStrategy;
    private Map<String, String> defaultSchedulingPeriodBySchedulingStrategy;
    private String defaultPenaltyDuration;
    private String defaultYieldDuration;
    private String defaultBulletinLevel;
    private List<Attribute> readsAttributes;
    private List<Attribute> writesAttributes;
    private List<UseCase> useCases;
    private List<MultiProcessorUseCase> multiProcessorUseCases;

    @Schema(description="Any input requirements this processor has.")
    public InputRequirement.Requirement getInputRequirement() {
        return this.inputRequirement;
    }

    public void setInputRequirement(InputRequirement.Requirement inputRequirement) {
        this.inputRequirement = inputRequirement;
    }

    @Schema(description="The supported relationships for this processor.")
    public List<Relationship> getSupportedRelationships() {
        return this.supportedRelationships == null ? Collections.emptyList() : Collections.unmodifiableList(this.supportedRelationships);
    }

    public void setSupportedRelationships(List<Relationship> supportedRelationships) {
        this.supportedRelationships = supportedRelationships;
    }

    @Schema(description="Whether or not this processor supports dynamic relationships.")
    public boolean getSupportsDynamicRelationships() {
        return this.supportsDynamicRelationships;
    }

    public void setSupportsDynamicRelationships(boolean supportsDynamicRelationships) {
        this.supportsDynamicRelationships = supportsDynamicRelationships;
    }

    @Schema(description="If the processor supports dynamic relationships, this describes the dynamic relationship")
    public DynamicRelationship getDynamicRelationship() {
        return this.dynamicRelationship;
    }

    public void setDynamicRelationship(DynamicRelationship dynamicRelationship) {
        this.dynamicRelationship = dynamicRelationship;
    }

    @Schema(description="Whether or not this processor should be triggered serially (i.e. no concurrent execution).")
    public boolean getTriggerSerially() {
        return this.triggerSerially;
    }

    public void setTriggerSerially(boolean triggerSerially) {
        this.triggerSerially = triggerSerially;
    }

    @Schema(description="Whether or not this processor should be triggered when incoming queues are empty.")
    public boolean getTriggerWhenEmpty() {
        return this.triggerWhenEmpty;
    }

    public void setTriggerWhenEmpty(boolean triggerWhenEmpty) {
        this.triggerWhenEmpty = triggerWhenEmpty;
    }

    @Schema(description="Whether or not this processor should be triggered when any destination queue has room.")
    public boolean getTriggerWhenAnyDestinationAvailable() {
        return this.triggerWhenAnyDestinationAvailable;
    }

    public void setTriggerWhenAnyDestinationAvailable(boolean triggerWhenAnyDestinationAvailable) {
        this.triggerWhenAnyDestinationAvailable = triggerWhenAnyDestinationAvailable;
    }

    @Schema(description="Whether or not this processor supports batching. If a Processor uses this annotation, it allows the Framework to batch calls to session commits, as well as allowing the Framework to return the same session multiple times.")
    public boolean getSupportsBatching() {
        return this.supportsBatching;
    }

    public void setSupportsBatching(boolean supportsBatching) {
        this.supportsBatching = supportsBatching;
    }

    @Schema(description="Whether or not this processor should be scheduled only on the primary node in a cluster.")
    public boolean getPrimaryNodeOnly() {
        return this.primaryNodeOnly;
    }

    public void setPrimaryNodeOnly(boolean primaryNodeOnly) {
        this.primaryNodeOnly = primaryNodeOnly;
    }

    @Schema(description="Whether or not this processor is considered side-effect free. Side-effect free indicate that the processor's operations on FlowFiles can be safely repeated across process sessions.")
    public boolean getSideEffectFree() {
        return this.sideEffectFree;
    }

    public void setSideEffectFree(boolean sideEffectFree) {
        this.sideEffectFree = sideEffectFree;
    }

    @Schema(description="The supported scheduling strategies, such as TIME_DRIVER, CRON, or EVENT_DRIVEN.")
    public List<String> getSupportedSchedulingStrategies() {
        return this.supportedSchedulingStrategies;
    }

    public void setSupportedSchedulingStrategies(List<String> supportedSchedulingStrategies) {
        this.supportedSchedulingStrategies = supportedSchedulingStrategies;
    }

    @Schema(description="The default scheduling strategy for the processor.")
    public String getDefaultSchedulingStrategy() {
        return this.defaultSchedulingStrategy;
    }

    public void setDefaultSchedulingStrategy(String defaultSchedulingStrategy) {
        this.defaultSchedulingStrategy = defaultSchedulingStrategy;
    }

    @Schema(description="The default concurrent tasks for each scheduling strategy.")
    public Map<String, Integer> getDefaultConcurrentTasksBySchedulingStrategy() {
        return this.defaultConcurrentTasksBySchedulingStrategy != null ? Collections.unmodifiableMap(this.defaultConcurrentTasksBySchedulingStrategy) : null;
    }

    public void setDefaultConcurrentTasksBySchedulingStrategy(Map<String, Integer> defaultConcurrentTasksBySchedulingStrategy) {
        this.defaultConcurrentTasksBySchedulingStrategy = defaultConcurrentTasksBySchedulingStrategy;
    }

    @Schema(description="The default scheduling period for each scheduling strategy. The scheduling period is expected to be a time period, such as \"30 sec\".")
    public Map<String, String> getDefaultSchedulingPeriodBySchedulingStrategy() {
        return this.defaultSchedulingPeriodBySchedulingStrategy != null ? Collections.unmodifiableMap(this.defaultSchedulingPeriodBySchedulingStrategy) : null;
    }

    public void setDefaultSchedulingPeriodBySchedulingStrategy(Map<String, String> defaultSchedulingPeriodBySchedulingStrategy) {
        this.defaultSchedulingPeriodBySchedulingStrategy = defaultSchedulingPeriodBySchedulingStrategy;
    }

    @Schema(description="The default penalty duration as a time period, such as \"30 sec\".")
    public String getDefaultPenaltyDuration() {
        return this.defaultPenaltyDuration;
    }

    public void setDefaultPenaltyDuration(String defaultPenaltyDuration) {
        this.defaultPenaltyDuration = defaultPenaltyDuration;
    }

    @Schema(description="The default yield duration as a time period, such as \"1 sec\".")
    public String getDefaultYieldDuration() {
        return this.defaultYieldDuration;
    }

    public void setDefaultYieldDuration(String defaultYieldDuration) {
        this.defaultYieldDuration = defaultYieldDuration;
    }

    @Schema(description="The default bulletin level, such as WARN, INFO, DEBUG, etc.")
    public String getDefaultBulletinLevel() {
        return this.defaultBulletinLevel;
    }

    public void setDefaultBulletinLevel(String defaultBulletinLevel) {
        this.defaultBulletinLevel = defaultBulletinLevel;
    }

    @Schema(description="The FlowFile attributes this processor reads")
    public List<Attribute> getReadsAttributes() {
        return this.readsAttributes;
    }

    public void setReadsAttributes(List<Attribute> readsAttributes) {
        this.readsAttributes = readsAttributes;
    }

    @Schema(description="The FlowFile attributes this processor writes/updates")
    public List<Attribute> getWritesAttributes() {
        return this.writesAttributes;
    }

    public void setWritesAttributes(List<Attribute> writesAttributes) {
        this.writesAttributes = writesAttributes;
    }

    @Schema(description="A list of use cases that have been documented for this Processor")
    public List<UseCase> getUseCases() {
        return this.useCases;
    }

    public void setUseCases(List<UseCase> useCases) {
        this.useCases = useCases;
    }

    @Schema(description="A list of use cases that have been documented that involve this Processor in conjunction with other Processors")
    public List<MultiProcessorUseCase> getMultiProcessorUseCases() {
        return this.multiProcessorUseCases;
    }

    public void setMultiProcessorUseCases(List<MultiProcessorUseCase> multiProcessorUseCases) {
        this.multiProcessorUseCases = multiProcessorUseCases;
    }
}

