/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliEncoder;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import io.netty.handler.codec.compression.SnappyOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdEncoder;
import io.netty.handler.codec.compression.ZstdOptions;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public class HttpContentCompressor
extends HttpContentEncoder {
    private final BrotliOptions brotliOptions;
    private final GzipOptions gzipOptions;
    private final DeflateOptions deflateOptions;
    private final ZstdOptions zstdOptions;
    private final SnappyOptions snappyOptions;
    private final int contentSizeThreshold;
    private ChannelHandlerContext ctx;
    private static final CompressionOptions[] DEFAULT_COMPRESSION_OPTIONS;

    public HttpContentCompressor() {
        this(0, (CompressionOptions[])null);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel) {
        this(compressionLevel, 15, 8, 0);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel, int windowBits, int memLevel) {
        this(compressionLevel, windowBits, memLevel, 0);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel, int windowBits, int memLevel, int contentSizeThreshold) {
        this(contentSizeThreshold, HttpContentCompressor.defaultCompressionOptions(StandardCompressionOptions.gzip((int)ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel"), (int)ObjectUtil.checkInRange((int)windowBits, (int)9, (int)15, (String)"windowBits"), (int)ObjectUtil.checkInRange((int)memLevel, (int)1, (int)9, (String)"memLevel")), StandardCompressionOptions.deflate((int)ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel"), (int)ObjectUtil.checkInRange((int)windowBits, (int)9, (int)15, (String)"windowBits"), (int)ObjectUtil.checkInRange((int)memLevel, (int)1, (int)9, (String)"memLevel"))));
    }

    public HttpContentCompressor(CompressionOptions ... compressionOptions) {
        this(0, compressionOptions);
    }

    public HttpContentCompressor(int contentSizeThreshold, CompressionOptions ... compressionOptions) {
        this.contentSizeThreshold = ObjectUtil.checkPositiveOrZero((int)contentSizeThreshold, (String)"contentSizeThreshold");
        BrotliOptions brotliOptions = null;
        GzipOptions gzipOptions = null;
        DeflateOptions deflateOptions = null;
        ZstdOptions zstdOptions = null;
        SnappyOptions snappyOptions = null;
        if (compressionOptions == null || compressionOptions.length == 0) {
            compressionOptions = DEFAULT_COMPRESSION_OPTIONS;
        }
        ObjectUtil.deepCheckNotNull((String)"compressionOptions", (Object[])compressionOptions);
        for (CompressionOptions compressionOption : compressionOptions) {
            if (Brotli.isAvailable() && compressionOption instanceof BrotliOptions) {
                brotliOptions = (BrotliOptions)compressionOption;
                continue;
            }
            if (compressionOption instanceof GzipOptions) {
                gzipOptions = (GzipOptions)compressionOption;
                continue;
            }
            if (compressionOption instanceof DeflateOptions) {
                deflateOptions = (DeflateOptions)compressionOption;
                continue;
            }
            if (Zstd.isAvailable() && compressionOption instanceof ZstdOptions) {
                zstdOptions = (ZstdOptions)compressionOption;
                continue;
            }
            if (compressionOption instanceof SnappyOptions) {
                snappyOptions = (SnappyOptions)compressionOption;
                continue;
            }
            throw new IllegalArgumentException("Unsupported " + CompressionOptions.class.getSimpleName() + ": " + compressionOption);
        }
        this.gzipOptions = gzipOptions;
        this.deflateOptions = deflateOptions;
        this.brotliOptions = brotliOptions;
        this.zstdOptions = zstdOptions;
        this.snappyOptions = snappyOptions;
    }

    @Deprecated
    private static CompressionOptions[] defaultCompressionOptions(GzipOptions gzipOptions, DeflateOptions deflateOptions) {
        ArrayList<Object> options = new ArrayList<Object>(5);
        options.add(gzipOptions);
        options.add(deflateOptions);
        options.add(StandardCompressionOptions.snappy());
        if (Brotli.isAvailable()) {
            options.add(StandardCompressionOptions.brotli());
        }
        if (Zstd.isAvailable()) {
            options.add(StandardCompressionOptions.zstd());
        }
        return options.toArray(new CompressionOptions[0]);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    @Override
    protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
        if (this.contentSizeThreshold > 0 && httpResponse instanceof HttpContent && ((HttpContent)((Object)httpResponse)).content().readableBytes() < this.contentSizeThreshold) {
            return null;
        }
        String contentEncoding = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding != null) {
            return null;
        }
        String targetContentEncoding = this.determineEncoding(acceptEncoding);
        if (targetContentEncoding == null) {
            return null;
        }
        Channel channel = this.ctx.channel();
        return new HttpContentEncoder.Result(targetContentEncoding, EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers(this.createEncoderFor(targetContentEncoding)).build());
    }

    private MessageToByteEncoder<ByteBuf> createEncoderFor(String targetContentEncoding) {
        switch (targetContentEncoding) {
            case "br": {
                if (this.brotliOptions == null || !Brotli.isAvailable()) {
                    throw new IllegalStateException("Brotli not configured");
                }
                return new BrotliEncoder(this.brotliOptions.parameters());
            }
            case "zstd": {
                if (this.zstdOptions == null) {
                    throw new IllegalStateException("Zstd not configured");
                }
                return new ZstdEncoder(this.zstdOptions.compressionLevel(), this.zstdOptions.blockSize(), this.zstdOptions.maxEncodeSize());
            }
            case "snappy": {
                if (this.snappyOptions == null) {
                    throw new IllegalStateException("Snappy not configured");
                }
                return new SnappyFrameEncoder();
            }
            case "gzip": {
                if (this.gzipOptions == null) {
                    throw new IllegalStateException("Gzip not configured");
                }
                return ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP, (int)this.gzipOptions.compressionLevel(), (int)this.gzipOptions.windowBits(), (int)this.gzipOptions.memLevel());
            }
            case "deflate": {
                if (this.deflateOptions == null) {
                    throw new IllegalStateException("Deflate not configured");
                }
                return ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.ZLIB, (int)this.deflateOptions.compressionLevel(), (int)this.deflateOptions.windowBits(), (int)this.deflateOptions.memLevel());
            }
        }
        throw new IllegalStateException("Unknown encoding: " + targetContentEncoding);
    }

    protected String determineEncoding(String acceptEncoding) {
        float starQ = -1.0f;
        float brQ = -1.0f;
        float zstdQ = -1.0f;
        float snappyQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        int start = 0;
        int length = acceptEncoding.length();
        while (start < length) {
            int comma = acceptEncoding.indexOf(44, start);
            if (comma == -1) {
                comma = length;
            }
            String encoding = acceptEncoding.substring(start, comma);
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
            } else if (encoding.contains("br") && q > brQ) {
                brQ = q;
            } else if (encoding.contains("zstd") && q > zstdQ) {
                zstdQ = q;
            } else if (encoding.contains("snappy") && q > snappyQ) {
                snappyQ = q;
            } else if (encoding.contains("gzip") && q > gzipQ) {
                gzipQ = q;
            } else if (encoding.contains("deflate") && q > deflateQ) {
                deflateQ = q;
            }
            start = comma + 1;
        }
        if (brQ > 0.0f || zstdQ > 0.0f || snappyQ > 0.0f || gzipQ > 0.0f || deflateQ > 0.0f) {
            if (brQ != -1.0f && brQ >= zstdQ && this.brotliOptions != null) {
                return "br";
            }
            if (zstdQ != -1.0f && zstdQ >= snappyQ && this.zstdOptions != null) {
                return "zstd";
            }
            if (snappyQ != -1.0f && snappyQ >= gzipQ && this.snappyOptions != null) {
                return "snappy";
            }
            if (gzipQ != -1.0f && gzipQ >= deflateQ && this.gzipOptions != null) {
                return "gzip";
            }
            if (deflateQ != -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        if (starQ > 0.0f) {
            if (brQ == -1.0f && this.brotliOptions != null) {
                return "br";
            }
            if (zstdQ == -1.0f && this.zstdOptions != null) {
                return "zstd";
            }
            if (snappyQ == -1.0f && this.snappyOptions != null) {
                return "snappy";
            }
            if (gzipQ == -1.0f && this.gzipOptions != null) {
                return "gzip";
            }
            if (deflateQ == -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        return null;
    }

    @Deprecated
    protected ZlibWrapper determineWrapper(String acceptEncoding) {
        float starQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        for (String encoding : acceptEncoding.split(",")) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
                continue;
            }
            if (encoding.contains("gzip") && q > gzipQ) {
                gzipQ = q;
                continue;
            }
            if (!encoding.contains("deflate") || !(q > deflateQ)) continue;
            deflateQ = q;
        }
        if (gzipQ > 0.0f || deflateQ > 0.0f) {
            if (gzipQ >= deflateQ) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (starQ > 0.0f) {
            if (gzipQ == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (deflateQ == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }

    static {
        ArrayList<Object> options = new ArrayList<Object>(5);
        options.add(StandardCompressionOptions.gzip());
        options.add(StandardCompressionOptions.deflate());
        options.add(StandardCompressionOptions.snappy());
        if (Brotli.isAvailable()) {
            options.add(StandardCompressionOptions.brotli());
        }
        if (Zstd.isAvailable()) {
            options.add(StandardCompressionOptions.zstd());
        }
        DEFAULT_COMPRESSION_OPTIONS = options.toArray(new CompressionOptions[0]);
    }
}

