/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.session;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.security.core.session.ReactiveSessionInformation;
import org.springframework.security.core.session.ReactiveSessionRegistry;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InMemoryReactiveSessionRegistry
implements ReactiveSessionRegistry {
    private final ConcurrentMap<Object, Set<String>> sessionIdsByPrincipal;
    private final Map<String, ReactiveSessionInformation> sessionById;

    public InMemoryReactiveSessionRegistry() {
        this.sessionIdsByPrincipal = new ConcurrentHashMap<Object, Set<String>>();
        this.sessionById = new ConcurrentHashMap<String, ReactiveSessionInformation>();
    }

    public InMemoryReactiveSessionRegistry(ConcurrentMap<Object, Set<String>> sessionIdsByPrincipal, Map<String, ReactiveSessionInformation> sessionById) {
        this.sessionIdsByPrincipal = sessionIdsByPrincipal;
        this.sessionById = sessionById;
    }

    @Override
    public Flux<ReactiveSessionInformation> getAllSessions(Object principal) {
        return Flux.fromIterable((Iterable)this.sessionIdsByPrincipal.getOrDefault(principal, Collections.emptySet())).mapNotNull(this.sessionById::get);
    }

    @Override
    public Mono<Void> saveSessionInformation(ReactiveSessionInformation information) {
        this.sessionById.put(information.getSessionId(), information);
        this.sessionIdsByPrincipal.computeIfAbsent(information.getPrincipal(), key -> new CopyOnWriteArraySet()).add(information.getSessionId());
        return Mono.empty();
    }

    @Override
    public Mono<ReactiveSessionInformation> getSessionInformation(String sessionId) {
        return Mono.justOrEmpty((Object)this.sessionById.get(sessionId));
    }

    @Override
    public Mono<ReactiveSessionInformation> removeSessionInformation(String sessionId) {
        return this.getSessionInformation(sessionId).doOnNext(sessionInformation -> {
            this.sessionById.remove(sessionId);
            Set sessionsUsedByPrincipal = (Set)this.sessionIdsByPrincipal.get(sessionInformation.getPrincipal());
            if (sessionsUsedByPrincipal != null) {
                sessionsUsedByPrincipal.remove(sessionId);
                if (sessionsUsedByPrincipal.isEmpty()) {
                    this.sessionIdsByPrincipal.remove(sessionInformation.getPrincipal());
                }
            }
        });
    }

    @Override
    public Mono<ReactiveSessionInformation> updateLastAccessTime(String sessionId) {
        ReactiveSessionInformation session = this.sessionById.get(sessionId);
        if (session != null) {
            return session.refreshLastRequest().thenReturn((Object)session);
        }
        return Mono.empty();
    }
}

