/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;

public final class PropertyMapper {
    private static final PropertyMapper INSTANCE = new PropertyMapper(null, null);
    private final @Nullable PropertyMapper parent;
    private final @Nullable SourceOperator sourceOperator;

    private PropertyMapper(@Nullable PropertyMapper parent, @Nullable SourceOperator sourceOperator) {
        this.parent = parent;
        this.sourceOperator = sourceOperator;
    }

    public PropertyMapper alwaysApplying(SourceOperator operator) {
        Assert.notNull((Object)operator, (String)"'operator' must not be null");
        return new PropertyMapper(this, operator);
    }

    public <T> Source<T> from(@Nullable T value) {
        return this.from(() -> value);
    }

    public <T> Source<T> from(Supplier<? extends @Nullable T> supplier) {
        Assert.notNull(supplier, (String)"'supplier' must not be null");
        Source<? extends T> source = this.getSource(supplier);
        if (this.sourceOperator != null) {
            source = this.sourceOperator.apply(source);
        }
        return source;
    }

    private <T> Source<T> getSource(Supplier<? extends @Nullable T> supplier) {
        if (this.parent != null) {
            return this.parent.from(supplier);
        }
        return new Source<Object>((Supplier<Object>)SingletonSupplier.of(supplier), value -> true);
    }

    public static PropertyMapper get() {
        return INSTANCE;
    }

    @FunctionalInterface
    public static interface SourceOperator {
        public <T> Source<T> apply(Source<T> var1);
    }

    public static final class Source<T> {
        private final Supplier<? extends @Nullable T> supplier;
        private final Predicate<T> predicate;

        private Source(Supplier<? extends @Nullable T> supplier, Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            this.supplier = supplier;
            this.predicate = predicate;
        }

        public Source<T> orFrom(Supplier<? extends @Nullable T> fallback) {
            Assert.notNull(fallback, (String)"'fallback' must not be null");
            Supplier<@Nullable Object> supplier = () -> {
                T value = this.getValue();
                return value != null ? value : fallback.get();
            };
            return new Source<Object>(supplier, this.predicate);
        }

        public <R extends Number> Source<Integer> asInt(Adapter<? super T, ? extends R> adapter) {
            return this.as(adapter).as(Number::intValue);
        }

        public <R> Source<R> as(Adapter<? super T, ? extends R> adapter) {
            Assert.notNull(adapter, (String)"'adapter' must not be null");
            Supplier<@Nullable Object> supplier = () -> {
                T value = this.getValue();
                return value != null && this.predicate.test(value) ? adapter.adapt((T)value) : null;
            };
            Predicate<Object> predicate = adaptedValue -> {
                T value = this.getValue();
                return value != null && this.predicate.test(value);
            };
            return new Source<Object>(supplier, predicate);
        }

        public Source<T> whenTrue() {
            return this.when(Boolean.TRUE::equals);
        }

        public Source<T> whenFalse() {
            return this.when(Boolean.FALSE::equals);
        }

        public Source<T> whenHasText() {
            return this.when(value -> StringUtils.hasText((String)value.toString()));
        }

        public Source<T> whenEqualTo(@Nullable Object object) {
            return this.when(value -> value.equals(object));
        }

        public <R extends T> Source<R> whenInstanceOf(Class<R> target) {
            Assert.notNull(target, (String)"'target' must not be null");
            return this.when(target::isInstance).as(target::cast);
        }

        public Source<T> whenNot(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            return this.when(predicate.negate());
        }

        public Source<T> when(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            return new Source<T>(this.supplier, this.predicate.and(predicate));
        }

        public void to(Consumer<? super T> consumer) {
            Assert.notNull(consumer, (String)"'consumer' must not be null");
            T value = this.getValue();
            if (value != null && this.test(value)) {
                consumer.accept(value);
            }
        }

        public <R> R to(R instance, BiFunction<R, ? super T, R> mapper) {
            Assert.notNull(instance, (String)"'instance' must not be null");
            Assert.notNull(mapper, (String)"'mapper' must not be null");
            T value = this.getValue();
            if (value != null && this.test(value)) {
                return mapper.apply(instance, value);
            }
            return instance;
        }

        public <R> R toInstance(Function<? super T, R> factory) {
            Assert.notNull(factory, (String)"'factory' must not be null");
            T value = this.getValue();
            if (value != null && this.test(value)) {
                return factory.apply(value);
            }
            throw new NoSuchElementException("No value present");
        }

        public void toCall(Runnable runnable) {
            Assert.notNull((Object)runnable, (String)"'runnable' must not be null");
            T value = this.getValue();
            if (value != null && this.test(value)) {
                runnable.run();
            }
        }

        public Always<T> always() {
            Supplier<@Nullable Object> getValue = this::getValue;
            return new Always<Object>(getValue, this::test);
        }

        private @Nullable T getValue() {
            try {
                return this.supplier.get();
            }
            catch (NullPointerException ex) {
                return null;
            }
        }

        private boolean test(T value) {
            Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
            return this.predicate.test(value);
        }

        @FunctionalInterface
        public static interface Adapter<T, R> {
            public @Nullable R adapt(T var1);
        }

        public static class Always<T> {
            private final Supplier<@Nullable T> supplier;
            private final Predicate<T> predicate;

            Always(Supplier<@Nullable T> supplier, Predicate<T> predicate) {
                this.supplier = supplier;
                this.predicate = predicate;
            }

            public <R> Always<R> as(Adapter<? super T, ? extends R> adapter) {
                Assert.notNull(adapter, (String)"'adapter' must not be null");
                Supplier<@Nullable Object> supplier = () -> {
                    T value = this.getValue();
                    return value == null || this.test(value) ? adapter.adapt((T)value) : null;
                };
                Predicate<Object> predicate = adaptedValue -> {
                    T value = this.getValue();
                    return value == null || this.test(value);
                };
                return new Always<Object>(supplier, predicate);
            }

            public void to(Consumer<@Nullable ? super T> consumer) {
                Assert.notNull(consumer, (String)"'consumer' must not be null");
                T value = this.getValue();
                if (value == null || this.test(value)) {
                    consumer.accept(value);
                }
            }

            public <R> R to(R instance, Mapper<R, ? super T> mapper) {
                Assert.notNull(instance, (String)"'instance' must not be null");
                Assert.notNull(mapper, (String)"'mapper' must not be null");
                T value = this.getValue();
                if (value == null || this.test(value)) {
                    return mapper.map(instance, value);
                }
                return instance;
            }

            public <R> R toInstance(Factory<? super T, ? extends R> factory) {
                Assert.notNull(factory, (String)"'factory' must not be null");
                T value = this.getValue();
                if (value == null || this.test(value)) {
                    return factory.create(value);
                }
                throw new NoSuchElementException("No value present");
            }

            public void toCall(Runnable runnable) {
                Assert.notNull((Object)runnable, (String)"'runnable' must not be null");
                T value = this.getValue();
                if (value == null || this.test(value)) {
                    runnable.run();
                }
            }

            private @Nullable T getValue() {
                return this.supplier.get();
            }

            private boolean test(T value) {
                Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
                return this.predicate.test(value);
            }

            @FunctionalInterface
            public static interface Adapter<T, R> {
                public @Nullable R adapt(@Nullable T var1);
            }

            @FunctionalInterface
            public static interface Mapper<R, T> {
                public R map(R var1, @Nullable T var2);
            }

            @FunctionalInterface
            public static interface Factory<T, R> {
                public R create(@Nullable T var1);
            }
        }
    }
}

