/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.animation.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v122.animation.model.AnimationEffect;
import org.openqa.selenium.json.JsonInput;

public class Animation {
    private final String id;
    private final String name;
    private final Boolean pausedState;
    private final String playState;
    private final Number playbackRate;
    private final Number startTime;
    private final Number currentTime;
    private final Type type;
    private final Optional<AnimationEffect> source;
    private final Optional<String> cssId;

    public Animation(String id, String name, Boolean pausedState, String playState, Number playbackRate, Number startTime, Number currentTime, Type type, Optional<AnimationEffect> source, Optional<String> cssId) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.pausedState = Objects.requireNonNull(pausedState, "pausedState is required");
        this.playState = Objects.requireNonNull(playState, "playState is required");
        this.playbackRate = Objects.requireNonNull(playbackRate, "playbackRate is required");
        this.startTime = Objects.requireNonNull(startTime, "startTime is required");
        this.currentTime = Objects.requireNonNull(currentTime, "currentTime is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.source = source;
        this.cssId = cssId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getPausedState() {
        return this.pausedState;
    }

    public String getPlayState() {
        return this.playState;
    }

    public Number getPlaybackRate() {
        return this.playbackRate;
    }

    public Number getStartTime() {
        return this.startTime;
    }

    public Number getCurrentTime() {
        return this.currentTime;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<AnimationEffect> getSource() {
        return this.source;
    }

    public Optional<String> getCssId() {
        return this.cssId;
    }

    private static Animation fromJson(JsonInput input) {
        String id = null;
        String name = null;
        Boolean pausedState = false;
        String playState = null;
        Number playbackRate = 0;
        Number startTime = 0;
        Number currentTime = 0;
        Type type = null;
        Optional<AnimationEffect> source = Optional.empty();
        Optional<String> cssId = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = input.nextString();
                    continue block24;
                }
                case "name": {
                    name = input.nextString();
                    continue block24;
                }
                case "pausedState": {
                    pausedState = input.nextBoolean();
                    continue block24;
                }
                case "playState": {
                    playState = input.nextString();
                    continue block24;
                }
                case "playbackRate": {
                    playbackRate = input.nextNumber();
                    continue block24;
                }
                case "startTime": {
                    startTime = input.nextNumber();
                    continue block24;
                }
                case "currentTime": {
                    currentTime = input.nextNumber();
                    continue block24;
                }
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block24;
                }
                case "source": {
                    source = Optional.ofNullable((AnimationEffect)input.read(AnimationEffect.class));
                    continue block24;
                }
                case "cssId": {
                    cssId = Optional.ofNullable(input.nextString());
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Animation(id, name, pausedState, playState, playbackRate, startTime, currentTime, type, source, cssId);
    }

    public static enum Type {
        CSSTRANSITION("CSSTransition"),
        CSSANIMATION("CSSAnimation"),
        WEBANIMATION("WebAnimation");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

