/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v107.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v107.audits.model.SourceCodeLocation;
import org.openqa.selenium.json.JsonInput;

public class NavigatorUserAgentIssueDetails {
    private final String url;
    private final Optional<SourceCodeLocation> location;

    public NavigatorUserAgentIssueDetails(String url, Optional<SourceCodeLocation> location) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.location = location;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<SourceCodeLocation> getLocation() {
        return this.location;
    }

    private static NavigatorUserAgentIssueDetails fromJson(JsonInput input) {
        String url = null;
        Optional<SourceCodeLocation> location = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block8;
                }
                case "location": {
                    location = Optional.ofNullable((SourceCodeLocation)input.read(SourceCodeLocation.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NavigatorUserAgentIssueDetails(url, location);
    }
}

