/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.webgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class LinkDatum
implements Writable {
    public static final byte INLINK = 1;
    public static final byte OUTLINK = 2;
    private String url = null;
    private String anchor = "";
    private float score = 0.0f;
    private long timestamp = 0L;
    private byte linkType = 0;

    public LinkDatum() {
    }

    public LinkDatum(String url) {
        this(url, "", System.currentTimeMillis());
    }

    public LinkDatum(String url, String anchor) {
        this(url, anchor, System.currentTimeMillis());
    }

    public LinkDatum(String url, String anchor, long timestamp) {
        this.url = url;
        this.anchor = anchor;
        this.timestamp = timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte getLinkType() {
        return this.linkType;
    }

    public void setLinkType(byte linkType) {
        this.linkType = linkType;
    }

    public void readFields(DataInput in) throws IOException {
        this.url = Text.readString((DataInput)in);
        this.anchor = Text.readString((DataInput)in);
        this.score = in.readFloat();
        this.timestamp = in.readLong();
        this.linkType = in.readByte();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.url);
        Text.writeString((DataOutput)out, (String)(this.anchor != null ? this.anchor : ""));
        out.writeFloat(this.score);
        out.writeLong(this.timestamp);
        out.writeByte(this.linkType);
    }

    public String toString() {
        String type = this.linkType == 1 ? "inlink" : (this.linkType == 2 ? "outlink" : "unknown");
        return "url: " + this.url + ", anchor: " + this.anchor + ", score: " + this.score + ", timestamp: " + this.timestamp + ", link type: " + type;
    }
}

