/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.resources;

import java.lang.invoke.MethodHandles;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.apache.nutch.service.model.response.JobInfo;
import org.apache.nutch.service.model.response.NutchServerInfo;
import org.apache.nutch.service.resources.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class AdminResource
extends AbstractResource {
    private final int DELAY_SEC = 1;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @GET
    @Path(value="/")
    public NutchServerInfo getServerStatus() {
        NutchServerInfo serverInfo = new NutchServerInfo();
        serverInfo.setConfiguration(this.configManager.list());
        serverInfo.setStartDate(new Date(this.server.getStarted()));
        serverInfo.setJobs(this.jobManager.list(null, JobInfo.State.ANY));
        serverInfo.setRunningJobs(this.jobManager.list(null, JobInfo.State.RUNNING));
        return serverInfo;
    }

    @GET
    @Path(value="/stop")
    public String stopServer(@QueryParam(value="force") boolean force) {
        if (!this.server.canStop(force)) {
            return "Jobs still running -- Cannot stop server now";
        }
        this.scheduleServerStop();
        return "Stopping in server on port " + this.server.getPort();
    }

    private void scheduleServerStop() {
        LOG.info("Shutting down server in {} sec", (Object)1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                AdminResource.this.server.stop();
                LOG.info("Service stopped.");
            }
        };
        thread.setDaemon(true);
        thread.start();
        LOG.info("Service shutting down...");
    }
}

