/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.json;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    private static final Logger LOG = Logger.getLogger(JSONUtils.class.getName());

    private static JSONObject getChild(JSONObject m, String child) {
        try {
            if (m.has(child)) {
                return m.getJSONObject(child);
            }
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
        return null;
    }

    public static JSONObject extractObject(JSONObject json, String path) {
        String[] parts = path.split("\\.");
        JSONObject cur = json;
        for (int i = 0; i < parts.length && (cur = JSONUtils.getChild(cur, parts[i])) != null; ++i) {
        }
        return cur;
    }

    public static JSONArray extractArray(JSONObject json, String path) {
        String[] parts = path.split("\\.");
        JSONObject cur = json;
        for (int i = 0; i < parts.length - 1 && (cur = JSONUtils.getChild(cur, parts[i])) != null; ++i) {
        }
        if (cur != null) {
            return cur.optJSONArray(parts[parts.length - 1]);
        }
        return null;
    }

    public static String extractSingle(JSONObject json, String path) {
        String last;
        String result = null;
        String[] parts = path.split("\\.");
        JSONObject cur = json;
        for (int i = 0; i < parts.length - 1 && (cur = JSONUtils.getChild(cur, parts[i])) != null; ++i) {
        }
        if (cur != null && cur.has(last = parts[parts.length - 1])) {
            try {
                result = cur.get(last).toString();
            }
            catch (JSONException e) {
                LOG.warning(e.getMessage());
            }
        }
        return result;
    }

    public static List<String> extractFancy(JSONObject json, String path) {
        ArrayList<String> matches = new ArrayList<String>();
        String[] parts = path.split("\\.");
        try {
            JSONUtils.extractRecursive(json, parts, 0, matches);
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
        return matches;
    }

    private static void extractRecursive(JSONObject json, String[] path, int idx, List<String> matches) throws JSONException {
        if (json == null) {
            return;
        }
        String part = path[idx];
        if (idx == path.length - 1) {
            if (json.has(part)) {
                matches.add(json.get(part).toString());
            }
        } else if (part.startsWith("@")) {
            if (json.has(part = part.substring(1))) {
                JSONArray a = json.getJSONArray(part);
                for (int i = 0; i < a.length(); ++i) {
                    JSONUtils.extractRecursive(a.getJSONObject(i), path, idx + 1, matches);
                }
            }
        } else {
            if (!part.startsWith("{") || part.endsWith("}")) {
                // empty if block
            }
            if (json.has(part)) {
                JSONUtils.extractRecursive(json.getJSONObject(part), path, idx + 1, matches);
            }
        }
    }
}

