/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.anvl;

import org.archive.util.anvl.ANVLRecord;

abstract class SubElement {
    private final String e;

    protected SubElement() {
        this(null);
    }

    public SubElement(String s) {
        this.e = this.baseCheck(s);
    }

    protected String baseCheck(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Can't be null");
        }
        for (int i = 0; i < s.length(); ++i) {
            this.checkCharacter(s.charAt(i), s, i);
        }
        return s;
    }

    protected void checkCharacter(char c, String srcStr, int index) {
        this.checkControlCharacter(c, srcStr, index);
        this.checkCRLF(c, srcStr, index);
    }

    protected void checkControlCharacter(char c, String srcStr, int index) {
        if (Character.isISOControl(c) && !Character.isWhitespace(c) || !Character.isValidCodePoint(c)) {
            throw new IllegalArgumentException(srcStr + " contains a control character(s) or invalid code point: 0x" + Integer.toHexString(c));
        }
    }

    protected void checkCRLF(char c, String srcStr, int index) {
        if (ANVLRecord.isCROrLF(c)) {
            throw new IllegalArgumentException(srcStr + " contains disallowed CRLF control character(s): 0x" + Integer.toHexString(c));
        }
    }

    public String toString() {
        return this.e;
    }
}

