/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.io.IOException;
import java.util.Iterator;
import org.archive.util.iterator.AbstractPeekableIterator;
import org.archive.util.iterator.CloseableIterator;
import org.archive.util.iterator.CloseableIteratorUtil;

public class BoundedStringIterator
extends AbstractPeekableIterator<String>
implements CloseableIterator<String> {
    private Iterator<String> inner;
    private String boundary;
    private boolean inclusive;
    private int flip;

    public BoundedStringIterator(Iterator<String> inner, String boundary) {
        this(inner, boundary, false);
    }

    public BoundedStringIterator(Iterator<String> inner, String boundary, boolean inclusive) {
        this(inner, boundary, inclusive, false);
    }

    public BoundedStringIterator(Iterator<String> inner, String boundary, boolean inclusive, boolean reverse) {
        this.inner = inner;
        this.boundary = boundary;
        this.inclusive = inclusive;
        this.flip = reverse ? -1 : 1;
    }

    @Override
    public String getNextInner() {
        String tmp = null;
        if (!(!this.inner.hasNext() || (tmp = this.inner.next()).compareTo(this.boundary) * this.flip < 0 || this.inclusive && tmp.startsWith(this.boundary))) {
            tmp = null;
            try {
                this.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return tmp;
    }

    @Override
    public void close() throws IOException {
        CloseableIteratorUtil.attemptClose(this.inner);
    }
}

