/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.zip;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.archive.util.zip.GzipHeader;
import org.archive.util.zip.OpenJDK7GZIPInputStream;

public class GZIPMembersInputStream
extends OpenJDK7GZIPInputStream {
    protected long memberNumber = 0L;
    protected long holdAtMemberNumber = Long.MAX_VALUE;
    protected long currentMemberStart = 0L;
    protected long currentMemberEnd = -1L;
    protected InputStream originalIn;

    public GZIPMembersInputStream(InputStream in) throws IOException {
        this(in, 512);
    }

    public GZIPMembersInputStream(InputStream in, int size) throws IOException {
        super(GZIPMembersInputStream.countingStream(in, size), size);
        this.originalIn = in;
    }

    protected static InputStream countingStream(InputStream in, int lookback) throws IOException {
        CountingInputStream cin = new CountingInputStream(in);
        cin.mark(lookback);
        return cin;
    }

    protected void updateInnerMark() {
        this.in.mark(this.buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.currentMemberEnd > 0L) {
            if (this.memberNumber >= this.holdAtMemberNumber) {
                return -1;
            }
            ++this.memberNumber;
            this.currentMemberStart = this.currentMemberEnd;
            this.currentMemberEnd = -1L;
        }
        return super.read(buf, off, len);
    }

    @Override
    protected boolean readTrailer() throws IOException {
        int c = this.inf.getRemaining();
        this.currentMemberEnd = ((CountingInputStream)this.in).getCount() - (long)(c - 8);
        InputStream in = this.in;
        int n = this.inf.getRemaining();
        if (n > 0) {
            in = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n, n), in);
        }
        if (this.readUInt(in) != this.crc.getValue() || this.readUInt(in) != (this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
            throw new ZipException("Corrupt GZIP trailer");
        }
        int m = 8;
        try {
        }
        catch (IOException ze) {
            return true;
        }
        this.inf.reset();
        if (n > (m += this.readHeader(in))) {
            this.inf.setInput(this.buf, this.len - n + m, n - m);
        }
        return false;
    }

    public void compressedSeek(long position) throws IOException {
        this.in.reset();
        long count = ((CountingInputStream)this.in).getCount();
        long delta = position - count;
        if (delta < 0L) {
            throw new IllegalArgumentException("can't seek backwards: seeked " + position + " already at " + count);
        }
        this.compressedSkip(delta);
    }

    public void compressedSkip(long offset) throws IOException {
        ByteStreams.skipFully((InputStream)this.in, (long)offset);
        this.updateInnerMark();
        this.currentMemberStart = ((CountingInputStream)this.in).getCount();
        this.currentMemberEnd = -1L;
        this.startNewMember();
    }

    protected void startNewMember() throws IOException {
        new GzipHeader(this.in);
        this.inf.reset();
        this.crc.reset();
        this.eos = false;
    }

    public boolean getAtMemberEnd() {
        return this.currentMemberEnd > 0L;
    }

    public long getMemberNumber() {
        return this.memberNumber;
    }

    public long getCurrentMemberStart() {
        return this.currentMemberStart;
    }

    public long getCurrentMemberEnd() {
        return this.currentMemberEnd;
    }

    public void setEofEachMember(boolean eofPerMember) {
        this.holdAtMemberNumber = eofPerMember ? this.memberNumber : Long.MAX_VALUE;
    }

    public void nextMember() {
        if (this.holdAtMemberNumber < Long.MAX_VALUE) {
            ++this.holdAtMemberNumber;
        }
    }

    public Inflater getInflater() {
        return this.inf;
    }

    public Iterator<GZIPMembersInputStream> memberIterator() {
        return new GZIPEnvelopeIterator();
    }

    public class GZIPEnvelopeIterator
    implements Iterator<GZIPMembersInputStream> {
        public GZIPEnvelopeIterator() {
            GZIPMembersInputStream.this.setEofEachMember(true);
        }

        @Override
        public boolean hasNext() {
            return !GZIPMembersInputStream.this.inf.finished();
        }

        @Override
        public GZIPMembersInputStream next() {
            if (GZIPMembersInputStream.this.getAtMemberEnd()) {
                GZIPMembersInputStream.this.nextMember();
            }
            if (this.hasNext()) {
                return GZIPMembersInputStream.this;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

