/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.RuntimeIOException;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.OleUtil;
import com.healthmarketscience.jackcess.util.MemFileChannel;
import com.healthmarketscience.jackcess.util.OleBlob;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class CompoundOleUtil
implements OleUtil.CompoundPackageFactory {
    private static final String ENTRY_NAME_CHARSET = "UTF-8";
    private static final String ENTRY_SEPARATOR = "/";
    private static final String CONTENTS_ENTRY = "CONTENTS";

    @Override
    public OleUtil.ContentImpl createCompoundPackageContent(OleUtil.OleBlobImpl blob, String prettyName, String className, String typeName, ByteBuffer blobBb, int dataBlockLen) {
        return new CompoundContentImpl(blob, prettyName, className, typeName, blobBb.position(), dataBlockLen);
    }

    public static DocumentEntry getDocumentEntry(String entryName, DirectoryEntry dir) throws IOException {
        ArrayList<String> entryNames = new ArrayList<String>();
        for (String str : entryName.split(ENTRY_SEPARATOR)) {
            if (str.length() == 0) continue;
            entryNames.add(CompoundOleUtil.decodeEntryName(str));
        }
        DocumentEntry entry = null;
        Iterator iter = entryNames.iterator();
        while (iter.hasNext()) {
            Entry tmpEntry = dir.getEntry((String)iter.next());
            if (tmpEntry instanceof DirectoryEntry) {
                dir = (DirectoryEntry)tmpEntry;
                continue;
            }
            if (iter.hasNext() || !(tmpEntry instanceof DocumentEntry)) break;
            entry = (DocumentEntry)tmpEntry;
        }
        if (entry == null) {
            throw new FileNotFoundException("Could not find document " + entryName);
        }
        return entry;
    }

    private static String encodeEntryName(String name) {
        try {
            return URLEncoder.encode(name, ENTRY_NAME_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String decodeEntryName(String name) {
        try {
            return URLDecoder.decode(name, ENTRY_NAME_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        POIFSFileSystem.class.getName();
    }

    private static final class CompoundContentImpl
    extends OleUtil.EmbeddedPackageContentImpl
    implements OleBlob.CompoundContent {
        private POIFSFileSystem _fs;

        private CompoundContentImpl(OleUtil.OleBlobImpl blob, String prettyName, String className, String typeName, int position, int length) {
            super(blob, prettyName, className, typeName, position, length);
        }

        @Override
        public OleBlob.ContentType getType() {
            return OleBlob.ContentType.COMPOUND_STORAGE;
        }

        private POIFSFileSystem getFileSystem() throws IOException {
            if (this._fs == null) {
                this._fs = new POIFSFileSystem(MemFileChannel.newChannel(this.getStream(), "r"));
            }
            return this._fs;
        }

        @Override
        public Iterator<OleBlob.CompoundContent.Entry> iterator() {
            try {
                return this.getEntries(new ArrayList<OleBlob.CompoundContent.Entry>(), this.getFileSystem().getRoot(), CompoundOleUtil.ENTRY_SEPARATOR).iterator();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public EntryImpl getEntry(String entryName) throws IOException {
            return new EntryImpl(entryName, CompoundOleUtil.getDocumentEntry(entryName, this.getFileSystem().getRoot()));
        }

        @Override
        public boolean hasContentsEntry() throws IOException {
            return this.getFileSystem().getRoot().hasEntry(CompoundOleUtil.CONTENTS_ENTRY);
        }

        @Override
        public EntryImpl getContentsEntry() throws IOException {
            return this.getEntry(CompoundOleUtil.CONTENTS_ENTRY);
        }

        private List<OleBlob.CompoundContent.Entry> getEntries(List<OleBlob.CompoundContent.Entry> entries, DirectoryEntry dir, String prefix) {
            for (Entry entry : dir) {
                if (entry instanceof DirectoryEntry) {
                    this.getEntries(entries, (DirectoryEntry)entry, prefix + CompoundOleUtil.ENTRY_SEPARATOR);
                    continue;
                }
                if (!(entry instanceof DocumentEntry)) continue;
                DocumentEntry de = (DocumentEntry)entry;
                String entryName = prefix + CompoundOleUtil.encodeEntryName(entry.getName());
                entries.add(new EntryImpl(entryName, de));
            }
            return entries;
        }

        @Override
        public void close() {
            ByteUtil.closeQuietly(this._fs);
            this._fs = null;
            super.close();
        }

        public String toString() {
            ToStringBuilder sb = this.toString(CustomToStringStyle.builder(this));
            try {
                sb.append("hasContentsEntry", this.hasContentsEntry());
                sb.append("entries", this.getEntries(new ArrayList<OleBlob.CompoundContent.Entry>(), this.getFileSystem().getRoot(), CompoundOleUtil.ENTRY_SEPARATOR));
            }
            catch (IOException e) {
                sb.append("entries", "<" + e + ">");
            }
            return sb.toString();
        }

        private final class EntryImpl
        implements OleBlob.CompoundContent.Entry {
            private final String _name;
            private final DocumentEntry _docEntry;

            private EntryImpl(String name, DocumentEntry docEntry) {
                this._name = name;
                this._docEntry = docEntry;
            }

            @Override
            public OleBlob.ContentType getType() {
                return OleBlob.ContentType.UNKNOWN;
            }

            @Override
            public String getName() {
                return this._name;
            }

            @Override
            public CompoundContentImpl getParent() {
                return CompoundContentImpl.this;
            }

            @Override
            public OleUtil.OleBlobImpl getBlob() {
                return this.getParent().getBlob();
            }

            @Override
            public long length() {
                return this._docEntry.getSize();
            }

            @Override
            public InputStream getStream() throws IOException {
                return new DocumentInputStream(this._docEntry);
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                InputStream in = null;
                try {
                    in = this.getStream();
                    ByteUtil.copy(in, out);
                }
                finally {
                    ByteUtil.closeQuietly(in);
                }
            }

            public String toString() {
                return CustomToStringStyle.valueBuilder(this).append("name", this._name).append("length", this.length()).toString();
            }
        }
    }
}

