/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dgn;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.SummaryExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.io.IOUtils;
import shaded.org.apache.commons.io.input.CloseShieldInputStream;

public class DGN8Parser
extends AbstractParser {
    Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.image((String)"vnd.dgn; version=8"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        SummaryExtractor summaryExtractor = new SummaryExtractor(metadata);
        TikaInputStream tstream = TikaInputStream.cast((InputStream)stream);
        POIFSFileSystem mustCloseFs = null;
        try {
            DirectoryNode root;
            if (tstream == null) {
                mustCloseFs = new POIFSFileSystem(new CloseShieldInputStream(stream));
                root = mustCloseFs.getRoot();
            } else {
                Object container = tstream.getOpenContainer();
                if (container instanceof POIFSFileSystem) {
                    root = ((POIFSFileSystem)container).getRoot();
                } else if (container instanceof DirectoryNode) {
                    root = (DirectoryNode)container;
                } else {
                    POIFSFileSystem fs = null;
                    fs = tstream.hasFile() ? new POIFSFileSystem(tstream.getFile(), true) : new POIFSFileSystem(new CloseShieldInputStream((InputStream)tstream));
                    tstream.setOpenContainer((Object)fs);
                    root = fs.getRoot();
                }
            }
            summaryExtractor.parseSummaries(root);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(mustCloseFs);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)mustCloseFs);
        xhtml.endDocument();
    }
}

