/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.index.analysis.NormalizingTokenFilterFactory;
import org.opensearch.index.analysis.PreConfiguredAnalysisComponent;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenFilter
extends PreConfiguredAnalysisComponent<TokenFilterFactory> {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(PreConfiguredTokenFilter.class);
    private final boolean useFilterForMultitermQueries;
    private final boolean allowForSynonymParsing;
    private final BiFunction<TokenStream, Version, TokenStream> create;

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, Function<TokenStream, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, boolean allowForSynonymParsing, Function<TokenStream, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, allowForSynonymParsing, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter luceneVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, org.apache.lucene.util.Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.LUCENE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, version.luceneVersion));
    }

    public static PreConfiguredTokenFilter openSearchVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, true, PreBuiltCacheFactory.CachingStrategy.OPENSEARCH, create);
    }

    public static PreConfiguredTokenFilter openSearchVersion(String name, boolean useFilterForMultitermQueries, boolean useFilterForParsingSynonyms, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, useFilterForParsingSynonyms, PreBuiltCacheFactory.CachingStrategy.OPENSEARCH, create);
    }

    private PreConfiguredTokenFilter(String name, boolean useFilterForMultitermQueries, boolean allowForSynonymParsing, PreBuiltCacheFactory.CachingStrategy cache, BiFunction<TokenStream, Version, TokenStream> create) {
        super(name, cache);
        this.useFilterForMultitermQueries = useFilterForMultitermQueries;
        this.allowForSynonymParsing = allowForSynonymParsing;
        this.create = create;
    }

    public boolean shouldUseFilterForMultitermQueries() {
        return this.useFilterForMultitermQueries;
    }

    @Override
    protected TokenFilterFactory create(final Version version) {
        if (this.useFilterForMultitermQueries) {
            return new NormalizingTokenFilterFactory(){

                @Override
                public TokenStream normalize(TokenStream tokenStream) {
                    return (TokenStream)PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
                }

                @Override
                public String name() {
                    return PreConfiguredTokenFilter.this.getName();
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return (TokenStream)PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
                }

                @Override
                public TokenFilterFactory getSynonymFilter() {
                    if (PreConfiguredTokenFilter.this.allowForSynonymParsing) {
                        return this;
                    }
                    if (version.onOrAfter(LegacyESVersion.V_7_0_0)) {
                        throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
                    }
                    DEPRECATION_LOGGER.deprecate(this.name() + "_synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
                    return this;
                }
            };
        }
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return PreConfiguredTokenFilter.this.getName();
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return (TokenStream)PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
            }

            @Override
            public TokenFilterFactory getSynonymFilter() {
                if (PreConfiguredTokenFilter.this.allowForSynonymParsing) {
                    return this;
                }
                if (version.onOrAfter(LegacyESVersion.V_7_0_0)) {
                    throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
                }
                DEPRECATION_LOGGER.deprecate(this.name() + "_synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
                return this;
            }
        };
    }
}

