/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.Set;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.bytes.CompositeBytesReference;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.transport.BytesTransportRequest;
import org.opensearch.transport.CompressibleBytesOutputStream;
import org.opensearch.transport.NetworkMessage;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.TcpHeader;
import org.opensearch.transport.TransportStatus;

abstract class OutboundMessage
extends NetworkMessage {
    private final Writeable message;

    OutboundMessage(ThreadContext threadContext, Version version, byte status, long requestId, Writeable message) {
        super(threadContext, version, status, requestId);
        this.message = message;
    }

    BytesReference serialize(BytesStreamOutput bytesStream) throws IOException {
        BytesReference reference;
        bytesStream.setVersion(this.version);
        bytesStream.skip(TcpHeader.headerSize(this.version));
        int variableHeaderLength = -1;
        long preHeaderPosition = bytesStream.position();
        if (this.version.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
            this.writeVariableHeader(bytesStream);
            variableHeaderLength = Math.toIntExact(bytesStream.position() - preHeaderPosition);
        }
        try (CompressibleBytesOutputStream stream = new CompressibleBytesOutputStream(bytesStream, TransportStatus.isCompress(this.status));){
            stream.setVersion(this.version);
            stream.setFeatures(bytesStream.getFeatures());
            if (variableHeaderLength == -1) {
                this.writeVariableHeader(stream);
            }
            reference = this.writeMessage(stream);
        }
        bytesStream.seek(0L);
        int contentSize = reference.length() - TcpHeader.headerSize(this.version);
        TcpHeader.writeHeader(bytesStream, this.requestId, this.status, this.version, contentSize, variableHeaderLength);
        return reference;
    }

    protected void writeVariableHeader(StreamOutput stream) throws IOException {
        this.threadContext.writeTo(stream);
    }

    protected BytesReference writeMessage(CompressibleBytesOutputStream stream) throws IOException {
        BytesReference zeroCopyBuffer;
        if (this.message instanceof BytesTransportRequest) {
            BytesTransportRequest bRequest = (BytesTransportRequest)this.message;
            bRequest.writeThin(stream);
            zeroCopyBuffer = bRequest.bytes;
        } else if (this.message instanceof RemoteTransportException) {
            stream.writeException((RemoteTransportException)this.message);
            zeroCopyBuffer = BytesArray.EMPTY;
        } else {
            this.message.writeTo(stream);
            zeroCopyBuffer = BytesArray.EMPTY;
        }
        BytesReference message = stream.materializeBytes();
        if (zeroCopyBuffer.length() == 0) {
            return message;
        }
        return CompositeBytesReference.of(message, zeroCopyBuffer);
    }

    private static boolean canCompress(Writeable message) {
        return !(message instanceof BytesTransportRequest);
    }

    static class Response
    extends OutboundMessage {
        private final Set<String> features;

        Response(ThreadContext threadContext, Set<String> features, Writeable message, Version version, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Response.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            stream.setFeatures(this.features);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setResponse(status);
            if (message instanceof RemoteTransportException) {
                status = TransportStatus.setError(status);
            }
            if (compress) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }

    static class Request
    extends OutboundMessage {
        private final String[] features;
        private final String action;

        Request(ThreadContext threadContext, String[] features, Writeable message, Version version, String action, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Request.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
            this.action = action;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            if (this.version.onOrAfter(LegacyESVersion.V_6_3_0)) {
                stream.writeStringArray(this.features);
            }
            stream.writeString(this.action);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setRequest(status);
            if (compress && OutboundMessage.canCompress(message)) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }
}

